/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.operators;

import java.util.ListIterator;
import proguard.analysis.cpa.bam.ReduceOperator;
import proguard.analysis.cpa.defaults.ListAbstractState;
import proguard.analysis.cpa.defaults.MapAbstractState;
import proguard.analysis.cpa.defaults.StackAbstractState;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.state.JvmFrameAbstractState;
import proguard.analysis.cpa.jvm.state.heap.JvmHeapAbstractState;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.classfile.util.ClassUtil;

public class DefaultReduceOperator<ContentT extends AbstractState<ContentT>>
implements ReduceOperator<ContentT> {
    private final boolean reduceHeap;

    public DefaultReduceOperator() {
        this(true);
    }

    public DefaultReduceOperator(boolean reduceHeap) {
        this.reduceHeap = reduceHeap;
    }

    @Override
    public JvmAbstractState<ContentT> reduceImpl(JvmAbstractState<ContentT> expandedInitialState, JvmCfaNode blockEntryNode, Call call) {
        AbstractState initialJvmState = expandedInitialState.copy();
        ((JvmAbstractState)initialJvmState).setProgramLocation(blockEntryNode);
        ListAbstractState localVariables = new ListAbstractState();
        StackAbstractState callStack = new StackAbstractState();
        JvmFrameAbstractState frame = new JvmFrameAbstractState(localVariables, callStack);
        int i = 0;
        if (call.getTarget().descriptor.argumentTypes != null) {
            int argSize = call.getJvmArgumentSize();
            ListIterator<String> iterator = call.getTarget().descriptor.argumentTypes.listIterator(call.getTarget().descriptor.argumentTypes.size());
            while (iterator.hasPrevious()) {
                String type = iterator.previous();
                int size = ClassUtil.internalTypeSize(type);
                Object state = ((JvmAbstractState)initialJvmState).peek(i++);
                localVariables.set(argSize - size, state, null);
                if (size == 2) {
                    state = ((JvmAbstractState)initialJvmState).peek(i++);
                    localVariables.set(argSize - size + 1, state, null);
                }
                argSize -= size;
            }
        }
        MapAbstractState staticFields = ((JvmAbstractState)initialJvmState).getStaticFields();
        this.reduceStaticFields(staticFields);
        if (!call.isStatic()) {
            Object state = ((JvmAbstractState)initialJvmState).peek(i);
            localVariables.set(0, state, null);
        }
        JvmHeapAbstractState heap = ((JvmAbstractState)initialJvmState).getHeap();
        if (this.reduceHeap) {
            this.reduceHeap(heap, frame, ((JvmAbstractState)initialJvmState).getStaticFields());
        }
        return this.createJvmAbstractState(((JvmAbstractState)initialJvmState).getProgramLocation(), frame, heap, ((JvmAbstractState)initialJvmState).getStaticFields());
    }

    protected void reduceStaticFields(MapAbstractState<String, ContentT> staticFields) {
    }

    protected void reduceHeap(JvmHeapAbstractState<ContentT> heap, JvmFrameAbstractState<ContentT> reducedFrame, MapAbstractState<String, ContentT> reducedStaticFields) {
    }

    protected JvmAbstractState<ContentT> createJvmAbstractState(JvmCfaNode programLocation, JvmFrameAbstractState<ContentT> frame, JvmHeapAbstractState<ContentT> heap, MapAbstractState<String, ContentT> staticFields) {
        return new JvmAbstractState<ContentT>(programLocation, frame, heap, staticFields);
    }
}

