/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.OptimizationInfoClassFilter;
import proguard.optimize.info.MethodOptimizationInfo;
import proguard.optimize.info.ProgramMethodOptimizationInfo;
import proguard.optimize.info.SideEffectClassMarker;
import proguard.optimize.info.SideEffectInstructionChecker;

public class SideEffectMethodMarker
implements MemberVisitor,
InstructionVisitor {
    private static final Logger logger = LogManager.getLogger(SideEffectMethodMarker.class);
    private final MemberVisitor extraMemberVisitor;
    private final SideEffectInstructionChecker sideEffectInstructionChecker;
    private final ClassVisitor sideEffectClassMarker = new OptimizationInfoClassFilter(new SideEffectClassMarker());

    public SideEffectMethodMarker(boolean optimizeConservatively) {
        this(null, optimizeConservatively);
    }

    public SideEffectMethodMarker(MemberVisitor extraMemberVisitor, boolean optimizeConservatively) {
        this.extraMemberVisitor = extraMemberVisitor;
        this.sideEffectInstructionChecker = new SideEffectInstructionChecker(false, true, optimizeConservatively);
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if ((programMethod.getAccessFlags() & 0x120) != 0) {
            this.markSideEffects((Clazz)programClass, (Method)programMethod);
        }
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        if (this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, offset, instruction)) {
            this.markSideEffects(clazz, method);
        }
    }

    private void markSideEffects(Clazz clazz, Method method) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (!methodOptimizationInfo.hasSideEffects() && methodOptimizationInfo instanceof ProgramMethodOptimizationInfo) {
            ((ProgramMethodOptimizationInfo)methodOptimizationInfo).setSideEffects();
            if (methodOptimizationInfo.hasSideEffects()) {
                logger.debug("SideEffectMethodMarker: marking for side-effects: {}.{}{}", (Object)clazz.getName(), (Object)method.getName(clazz), (Object)method.getDescriptor(clazz));
                if (this.extraMemberVisitor != null) {
                    method.accept(clazz, this.extraMemberVisitor);
                }
                if (method.getName(clazz).equals("<clinit>")) {
                    clazz.accept(this.sideEffectClassMarker);
                }
            }
        }
    }

    public static boolean hasSideEffects(Method method) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).hasSideEffects();
    }
}

