/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.SingleTimeAttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.InstructionSequenceMatcher;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.InvocationUnit;
import proguard.evaluation.PartialEvaluator;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.TypedReferenceValueFactory;
import proguard.evaluation.value.ValueFactory;
import proguard.optimize.gson.TypeArgumentFinder;

public class GsonDeserializationInvocationFinder
implements InstructionVisitor {
    private static final Logger logger = LogManager.getLogger(GsonDeserializationInvocationFinder.class);
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final ClassVisitor domainClassVisitor;
    private final WarningPrinter warningPrinter;
    private final FromJsonInvocationMatcher[] fromJsonInvocationMatchers;
    private final TypedReferenceValueFactory valueFactory = new TypedReferenceValueFactory();
    private final PartialEvaluator partialEvaluator = PartialEvaluator.Builder.create().setValueFactory((ValueFactory)this.valueFactory).setInvocationUnit((InvocationUnit)new BasicInvocationUnit((ValueFactory)this.valueFactory)).setEvaluateAllCode(true).build();
    private final AttributeVisitor lazyPartialEvaluator = new AttributeNameFilter("Code", (AttributeVisitor)new SingleTimeAttributeVisitor((AttributeVisitor)this.partialEvaluator));

    public GsonDeserializationInvocationFinder(ClassPool programClassPool, ClassPool libraryClassPool, ClassVisitor domainClassVisitor, WarningPrinter warningPrinter) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.domainClassVisitor = domainClassVisitor;
        this.warningPrinter = warningPrinter;
        InstructionSequenceBuilder builder = new InstructionSequenceBuilder();
        Instruction[] fromJsonStringClassInstructions = builder.invokevirtual("com/google/gson/Gson", "fromJson", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;").instructions();
        Instruction[] fromJsonStringTypeInstructions = builder.invokevirtual("com/google/gson/Gson", "fromJson", "(Ljava/lang/String;Ljava/lang/reflect/Type;)Ljava/lang/Object;").instructions();
        Instruction[] fromJsonReaderClassInstructions = builder.invokevirtual("com/google/gson/Gson", "fromJson", "(Ljava/io/Reader;Ljava/lang/Class;)Ljava/lang/Object;").instructions();
        Instruction[] fromJsonReaderTypeInstructions = builder.invokevirtual("com/google/gson/Gson", "fromJson", "(Ljava/io/Reader;Ljava/lang/reflect/Type;)Ljava/lang/Object;").instructions();
        Instruction[] fromJsonJsonReaderTypeInstructions = builder.invokevirtual("com/google/gson/Gson", "fromJson", "(Lcom/google/gson/stream/JsonReader;Ljava/lang/reflect/Type;)Ljava/lang/Object;").instructions();
        Constant[] constants = builder.constants();
        this.fromJsonInvocationMatchers = new FromJsonInvocationMatcher[]{new FromJsonInvocationMatcher(constants, fromJsonStringClassInstructions, 0, -1), new FromJsonInvocationMatcher(constants, fromJsonStringTypeInstructions, -1, 0), new FromJsonInvocationMatcher(constants, fromJsonReaderClassInstructions, 0, -1), new FromJsonInvocationMatcher(constants, fromJsonReaderTypeInstructions, -1, 0), new FromJsonInvocationMatcher(constants, fromJsonJsonReaderTypeInstructions, -1, 0)};
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        FromJsonInvocationMatcher matchingMatcher = null;
        for (FromJsonInvocationMatcher matcher : this.fromJsonInvocationMatchers) {
            instruction.accept(clazz, method, codeAttribute, offset, (InstructionVisitor)matcher);
            if (!matcher.isMatching()) continue;
            matchingMatcher = matcher;
            break;
        }
        if (matchingMatcher != null) {
            logger.debug("GsonDeserializationInvocationFinder: Gson#fromJson: {}.{}{} {}", (Object)clazz.getName(), (Object)method.getName(clazz), (Object)method.getDescriptor(clazz), (Object)instruction.toString(offset));
            this.lazyPartialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
            int stackElementIndex = matchingMatcher.typeStackElementIndex == -1 ? matchingMatcher.classStackElementIndex : matchingMatcher.typeStackElementIndex;
            InstructionOffsetValue producer = this.partialEvaluator.getStackBefore(offset).getTopActualProducerValue(stackElementIndex).instructionOffsetValue();
            TypeArgumentFinder typeArgumentFinder = new TypeArgumentFinder(this.programClassPool, this.libraryClassPool, this.partialEvaluator);
            for (int i = 0; i < producer.instructionOffsetCount(); ++i) {
                codeAttribute.instructionAccept(clazz, method, producer.instructionOffset(i), (InstructionVisitor)typeArgumentFinder);
            }
            String[] targetTypes = typeArgumentFinder.typeArgumentClasses;
            if (targetTypes != null) {
                for (String targetType : targetTypes) {
                    logger.debug("GsonDeserializationInvocationFinder: deserialized type: {}", (Object)targetType);
                    this.programClassPool.classAccept(targetType, this.domainClassVisitor);
                }
            } else if (this.warningPrinter != null) {
                this.warningPrinter.print(clazz.getName(), "Warning: can't derive deserialized type from fromJson() invocation in " + clazz.getName() + "." + method.getName(clazz) + method.getDescriptor(clazz));
            }
        }
    }

    private static class FromJsonInvocationMatcher
    extends InstructionSequenceMatcher {
        private int classStackElementIndex;
        private int typeStackElementIndex;

        private FromJsonInvocationMatcher(Constant[] patternConstants, Instruction[] patternInstructions, int classStackElementIndex, int typeStackElementIndex) {
            super(patternConstants, patternInstructions);
            this.classStackElementIndex = classStackElementIndex;
            this.typeStackElementIndex = typeStackElementIndex;
        }
    }
}

