/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.VariableRemapper;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.ParameterUsageMarker;

public class ParameterShrinker
implements AttributeVisitor {
    private static final Logger logger = LogManager.getLogger(ParameterShrinker.class);
    private final MemberVisitor extraUnusedParameterMethodVisitor;
    private final VariableRemapper variableRemapper = new VariableRemapper();

    public ParameterShrinker() {
        this(null);
    }

    public ParameterShrinker(MemberVisitor extraUnusedParameterMethodVisitor) {
        this.extraUnusedParameterMethodVisitor = extraUnusedParameterMethodVisitor;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        int newParameterSize;
        int oldParameterSize = ParameterUsageMarker.getParameterSize(method);
        if (oldParameterSize > (newParameterSize = ClassUtil.internalMethodParameterSize((String)method.getDescriptor(clazz), (int)method.getAccessFlags()))) {
            int maxLocals = codeAttribute.u2maxLocals;
            logger.debug("ParameterShrinker: {}.{}{}", (Object)clazz.getName(), (Object)method.getName(clazz), (Object)method.getDescriptor(clazz));
            logger.debug("  Old parameter size = {}", (Object)oldParameterSize);
            logger.debug("  New parameter size = {}", (Object)newParameterSize);
            logger.debug("  Max locals         = {}", (Object)maxLocals);
            int[] variableMap = new int[maxLocals];
            int usedParameterIndex = 0;
            int unusedParameterIndex = newParameterSize;
            for (int parameterIndex = 0; parameterIndex < oldParameterSize; ++parameterIndex) {
                if (ParameterUsageMarker.isParameterUsed(method, parameterIndex)) {
                    variableMap[parameterIndex] = usedParameterIndex++;
                    continue;
                }
                logger.debug("  Deleting parameter #{}", (Object)parameterIndex);
                variableMap[parameterIndex] = unusedParameterIndex++;
                if (this.extraUnusedParameterMethodVisitor == null) continue;
                method.accept(clazz, this.extraUnusedParameterMethodVisitor);
            }
            for (int variableIndex = oldParameterSize; variableIndex < maxLocals; ++variableIndex) {
                variableMap[variableIndex] = variableIndex;
            }
            this.variableRemapper.setVariableMap(variableMap);
            this.variableRemapper.visitCodeAttribute(clazz, method, codeAttribute);
        }
    }
}

