/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import proguard.classfile.Clazz;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.WarningPrinter;

public class GetEnclosingMethodChecker
implements ConstantVisitor {
    private final WarningPrinter notePrinter;

    public GetEnclosingMethodChecker(WarningPrinter notePrinter) {
        this.notePrinter = notePrinter;
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
        String methodName;
        String className = methodrefConstant.getClassName(clazz);
        if (className.equals("java/lang/Class") && ((methodName = methodrefConstant.getName(clazz)).equals("getEnclosingConstructor") || methodName.equals("getEnclosingMethod"))) {
            this.notePrinter.print(clazz.getName(), "Note: " + ClassUtil.externalClassName((String)clazz.getName()) + " calls '" + ClassUtil.externalShortClassName((String)ClassUtil.externalClassName((String)className)) + "." + methodName + "'");
        }
    }
}

