/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalars.locale;

import graphql.Internal;
import graphql.language.StringValue;
import graphql.scalars.util.Kit;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.util.Locale;

@Internal
public class LocaleScalar
extends GraphQLScalarType {
    public LocaleScalar() {
        super("Locale", "A IETF BCP 47 language tag", (Coercing)new Coercing<Locale, String>(){

            public String serialize(Object input) throws CoercingSerializeException {
                if (input instanceof String) {
                    try {
                        return Locale.forLanguageTag((String)input).toLanguageTag();
                    }
                    catch (Exception e) {
                        throw new CoercingSerializeException("Expected a valid language tag string but was but was " + Kit.typeName(input));
                    }
                }
                if (input instanceof Locale) {
                    return ((Locale)input).toLanguageTag();
                }
                throw new CoercingSerializeException("Expected a 'java.util.Locale' object but was " + Kit.typeName(input));
            }

            public Locale parseValue(Object input) throws CoercingParseValueException {
                if (input instanceof String) {
                    try {
                        return Locale.forLanguageTag(input.toString());
                    }
                    catch (Exception e) {
                        throw new CoercingParseValueException("Unable to parse value to 'java.util.Locale' because of: " + e.getMessage());
                    }
                }
                throw new CoercingParseValueException("Expected a 'java.lang.String' object but was " + Kit.typeName(input));
            }

            public Locale parseLiteral(Object input) throws CoercingParseLiteralException {
                if (input instanceof StringValue) {
                    return Locale.forLanguageTag(((StringValue)input).getValue());
                }
                throw new CoercingParseLiteralException("Expected a 'java.lang.String' object but was " + Kit.typeName(input));
            }
        });
    }
}

