/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.autoconfigure.scalars;

import graphql.schema.GraphQLScalarType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.util.ReflectionUtils;

public final class GraphQLScalarUtils {
    public static Map<String, GraphQLScalarType> extractScalarDefinitions(Class<?> ... classes) {
        HashMap<String, GraphQLScalarType> scalarTypes = new HashMap<String, GraphQLScalarType>();
        Stream.of(classes).forEach(clazz -> GraphQLScalarUtils.extractScalarField(clazz, scalarTypes));
        return scalarTypes;
    }

    private static void extractScalarField(Class<?> clazz, Map<String, GraphQLScalarType> target) {
        ReflectionUtils.doWithFields(clazz, scalarField -> GraphQLScalarUtils.extractedIfScalarField(target, scalarField));
    }

    private static void extractedIfScalarField(Map<String, GraphQLScalarType> target, Field field) throws IllegalAccessException {
        if (Modifier.isPublic(field.getModifiers()) && Modifier.isStatic(field.getModifiers()) && field.getType().equals(GraphQLScalarType.class)) {
            GraphQLScalarType graphQLScalarType = (GraphQLScalarType)field.get(null);
            target.put(graphQLScalarType.getName(), graphQLScalarType);
        }
    }

    @Generated
    private GraphQLScalarUtils() {
    }
}

