/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.autoconfigure.scalars;

import graphql.Scalars;
import graphql.kickstart.autoconfigure.scalars.GraphQLScalarUtils;
import graphql.scalars.ExtendedScalars;
import graphql.schema.GraphQLScalarType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;

public class GraphQLAliasedScalarsInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    private static final String GRAPHQL_ALIASED_SCALAR_PREFIX = "graphql.aliased-scalars.";
    private static final String JOINING_SEPARATOR = ", ";
    private static final String NO_BUILT_IN_SCALAR_FOUND = "Scalar(s) '%s' cannot be aliased. Only the following scalars can be aliased by configuration: %s. Note that custom scalar beans cannot be aliased this way.";

    public void initialize(@NonNull GenericApplicationContext applicationContext) {
        if (applicationContext == null) {
            throw new NullPointerException("applicationContext is marked non-null but is null");
        }
        Map<String, GraphQLScalarType> predefinedScalars = GraphQLScalarUtils.extractScalarDefinitions(Scalars.class, ExtendedScalars.class);
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        this.verifyAliasedScalarConfiguration(predefinedScalars, environment);
        predefinedScalars.forEach((scalarName, scalarType) -> ((List)environment.getProperty(GRAPHQL_ALIASED_SCALAR_PREFIX + scalarName, List.class, Collections.emptyList())).stream().map(String::valueOf).map(alias -> ExtendedScalars.newAliasedScalar((String)alias).aliasedScalar(scalarType).build()).forEach(aliasedScalar -> applicationContext.registerBean(aliasedScalar.getName(), GraphQLScalarType.class, () -> aliasedScalar, new BeanDefinitionCustomizer[0])));
    }

    private void verifyAliasedScalarConfiguration(Map<String, GraphQLScalarType> predefinedScalars, ConfigurableEnvironment environment) {
        List invalidScalars = environment.getPropertySources().stream().filter(pSource -> pSource instanceof EnumerablePropertySource).map(pSource -> (EnumerablePropertySource)pSource).map(EnumerablePropertySource::getPropertyNames).flatMap(Arrays::stream).filter(pName -> pName.startsWith(GRAPHQL_ALIASED_SCALAR_PREFIX)).map(pName -> pName.replace(GRAPHQL_ALIASED_SCALAR_PREFIX, "")).filter(scalarName -> !predefinedScalars.containsKey(scalarName)).sorted().collect(Collectors.toList());
        if (!invalidScalars.isEmpty()) {
            String validBuildInScalars = predefinedScalars.keySet().stream().sorted().collect(Collectors.joining(JOINING_SEPARATOR));
            throw new ApplicationContextException(String.format(NO_BUILT_IN_SCALAR_FOUND, String.join((CharSequence)JOINING_SEPARATOR, invalidScalars), validBuildInScalars));
        }
    }

    @Generated
    public GraphQLAliasedScalarsInitializer() {
    }
}

