/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.autoconfigure.annotations;

import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.typeFunctions.TypeFunction;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLScalarTypeFunction
implements TypeFunction {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraphQLScalarTypeFunction.class);
    private final List<GraphQLScalarType> customScalarTypes;

    public boolean canBuildType(Class<?> aClass, AnnotatedType annotatedType) {
        return this.getMatchingScalarDefinition(aClass).isPresent();
    }

    public GraphQLType buildType(boolean input, Class<?> aClass, AnnotatedType annotatedType, ProcessingElementsContainer container) {
        GraphQLScalarType graphQLScalarType = this.getMatchingScalarDefinition(aClass).orElse(null);
        if (Objects.nonNull(graphQLScalarType)) {
            log.info("Registering scalar type {} for Java class {}", (Object)graphQLScalarType.getName(), aClass);
        }
        return graphQLScalarType;
    }

    private Optional<GraphQLScalarType> getMatchingScalarDefinition(Class<?> aClass) {
        return this.customScalarTypes.stream().filter(scalarType -> {
            Type[] genericInterfaces = scalarType.getCoercing().getClass().getGenericInterfaces();
            return genericInterfaces.length > 0 && genericInterfaces[0] instanceof ParameterizedType && ((ParameterizedType)genericInterfaces[0]).getActualTypeArguments().length > 0 && ((ParameterizedType)genericInterfaces[0]).getActualTypeArguments()[0].equals(aClass);
        }).findFirst();
    }

    @Generated
    public GraphQLScalarTypeFunction(List<GraphQLScalarType> customScalarTypes) {
        this.customScalarTypes = customScalarTypes;
    }
}

