/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.spring.webflux.boot;

import graphql.kickstart.tools.SchemaParser;
import graphql.kickstart.tools.SchemaParserOptions;
import graphql.kickstart.tools.boot.GraphQLJavaToolsAutoConfiguration;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.core.publisher.Mono;

@Configuration
@ConditionalOnClass(value={SchemaParser.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@AutoConfigureBefore(value={GraphQLJavaToolsAutoConfiguration.class})
public class MonoAutoConfiguration {
    @Bean
    SchemaParserOptions.GenericWrapper monoWrapper(@Autowired(required=false) List<SchemaParserOptions.GenericWrapper> genericWrappers) {
        if (this.notWrapsMono(genericWrappers)) {
            return SchemaParserOptions.GenericWrapper.withTransformer(Mono.class, (int)0, Mono::toFuture, t -> t);
        }
        return null;
    }

    private boolean notWrapsMono(List<SchemaParserOptions.GenericWrapper> genericWrappers) {
        return genericWrappers == null || genericWrappers.stream().noneMatch(it -> it.getType().isAssignableFrom(Mono.class));
    }
}

