/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.ArrayTernaryTrie;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.ArrayTrie;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.StringUtil;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Trie;
import java.nio.ByteBuffer;

public enum HttpMethod {
    ACL(Type.IDEMPOTENT),
    BASELINE_CONTROL(Type.IDEMPOTENT),
    BIND(Type.IDEMPOTENT),
    CHECKIN(Type.IDEMPOTENT),
    CHECKOUT(Type.IDEMPOTENT),
    CONNECT(Type.NORMAL),
    COPY(Type.IDEMPOTENT),
    DELETE(Type.IDEMPOTENT),
    GET(Type.SAFE),
    HEAD(Type.SAFE),
    LABEL(Type.IDEMPOTENT),
    LINK(Type.IDEMPOTENT),
    LOCK(Type.NORMAL),
    MERGE(Type.IDEMPOTENT),
    MKACTIVITY(Type.IDEMPOTENT),
    MKCALENDAR(Type.IDEMPOTENT),
    MKCOL(Type.IDEMPOTENT),
    MKREDIRECTREF(Type.IDEMPOTENT),
    MKWORKSPACE(Type.IDEMPOTENT),
    MOVE(Type.IDEMPOTENT),
    OPTIONS(Type.SAFE),
    ORDERPATCH(Type.IDEMPOTENT),
    PATCH(Type.NORMAL),
    POST(Type.NORMAL),
    PRI(Type.SAFE),
    PROPFIND(Type.SAFE),
    PROPPATCH(Type.IDEMPOTENT),
    PUT(Type.IDEMPOTENT),
    REBIND(Type.IDEMPOTENT),
    REPORT(Type.SAFE),
    SEARCH(Type.SAFE),
    TRACE(Type.SAFE),
    UNBIND(Type.IDEMPOTENT),
    UNCHECKOUT(Type.IDEMPOTENT),
    UNLINK(Type.IDEMPOTENT),
    UNLOCK(Type.IDEMPOTENT),
    UPDATE(Type.IDEMPOTENT),
    UPDATEREDIRECTREF(Type.IDEMPOTENT),
    VERSION_CONTROL(Type.IDEMPOTENT),
    PROXY(Type.NORMAL);

    private final String _method = this.name().replace('_', '-');
    private final byte[] _bytes;
    private final ByteBuffer _buffer;
    private final Type _type;
    public static final Trie<HttpMethod> INSENSITIVE_CACHE;
    public static final Trie<HttpMethod> CACHE;
    public static final Trie<HttpMethod> LOOK_AHEAD;
    public static final int ACL_AS_INT = 1094929440;
    public static final int GET_AS_INT = 1195725856;
    public static final int PRI_AS_INT = 1347569952;
    public static final int PUT_AS_INT = 1347769376;
    public static final int POST_AS_INT = 1347375956;
    public static final int HEAD_AS_INT = 1212498244;

    private HttpMethod(Type type) {
        this._type = type;
        this._bytes = StringUtil.getBytes(this._method);
        this._buffer = ByteBuffer.wrap(this._bytes);
    }

    public boolean is(String string) {
        return this.toString().equalsIgnoreCase(string);
    }

    public String asString() {
        return this._method;
    }

    public String toString() {
        return this._method;
    }

    public static HttpMethod lookAheadGet(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        if (n2 > 3) {
            switch (byteBuffer.getInt(byteBuffer.position())) {
                case 1094929440: {
                    return ACL;
                }
                case 1195725856: {
                    return GET;
                }
                case 1347569952: {
                    return PRI;
                }
                case 1347769376: {
                    return PUT;
                }
                case 1347375956: {
                    if (n2 <= 4 || byteBuffer.get(byteBuffer.position() + 4) != 32) break;
                    return POST;
                }
                case 1212498244: {
                    if (n2 <= 4 || byteBuffer.get(byteBuffer.position() + 4) != 32) break;
                    return HEAD;
                }
            }
        }
        return LOOK_AHEAD.getBest(byteBuffer, 0, n2);
    }

    static {
        INSENSITIVE_CACHE = new ArrayTrie<HttpMethod>(252);
        CACHE = new ArrayTernaryTrie<HttpMethod>(false, 300);
        LOOK_AHEAD = new ArrayTernaryTrie<HttpMethod>(false, 330);
        for (HttpMethod httpMethod : HttpMethod.values()) {
            if (!INSENSITIVE_CACHE.put(httpMethod.asString(), httpMethod)) {
                throw new IllegalStateException("INSENSITIVE_CACHE too small: " + (Object)((Object)httpMethod));
            }
            if (!CACHE.put(httpMethod.asString(), httpMethod)) {
                throw new IllegalStateException("CACHE too small: " + (Object)((Object)httpMethod));
            }
            if (LOOK_AHEAD.put(httpMethod.asString() + ' ', httpMethod)) continue;
            throw new IllegalStateException("LOOK_AHEAD too small: " + (Object)((Object)httpMethod));
        }
    }

    private static enum Type {
        NORMAL,
        IDEMPOTENT,
        SAFE;

    }
}

