/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpExchange;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Response;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.AttributesMap;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;

public class HttpConversation
extends AttributesMap {
    private static final Logger LOG = Log.getLogger(HttpConversation.class);
    private final Deque<HttpExchange> exchanges = new ConcurrentLinkedDeque<HttpExchange>();
    private volatile List<Response.ResponseListener> listeners;

    public Deque<HttpExchange> getExchanges() {
        return this.exchanges;
    }

    public List<Response.ResponseListener> getResponseListeners() {
        return this.listeners;
    }

    public void updateResponseListeners(Response.ResponseListener responseListener) {
        HttpExchange httpExchange = this.exchanges.peekFirst();
        HttpExchange httpExchange2 = this.exchanges.peekLast();
        ArrayList<Response.ResponseListener> arrayList = new ArrayList<Response.ResponseListener>(httpExchange.getResponseListeners().size() + httpExchange2.getResponseListeners().size());
        if (httpExchange == httpExchange2) {
            if (responseListener != null) {
                arrayList.add(responseListener);
            } else {
                arrayList.addAll(httpExchange.getResponseListeners());
            }
        } else {
            arrayList.addAll(httpExchange2.getResponseListeners());
            if (responseListener != null) {
                arrayList.add(responseListener);
            } else {
                arrayList.addAll(httpExchange.getResponseListeners());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exchanges in conversation {}, override={}, listeners={}", this.exchanges.size(), responseListener, arrayList);
        }
        this.listeners = arrayList;
    }

    public long getTimeout() {
        HttpExchange httpExchange = this.exchanges.peekFirst();
        return httpExchange == null ? 0L : httpExchange.getRequest().getTimeout();
    }

    public boolean abort(Throwable throwable) {
        HttpExchange httpExchange = this.exchanges.peekLast();
        return httpExchange != null && httpExchange.abort(throwable);
    }

    @Override
    public String toString() {
        return String.format("%s[%x]", HttpConversation.class.getSimpleName(), this.hashCode());
    }
}

