/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.http.impl.conn;

import com.gradle.maven.extension.internal.dep.org.apache.commons.logging.Log;
import com.gradle.maven.extension.internal.dep.org.apache.commons.logging.LogFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpException;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpResponse;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpResponseFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.NoHttpResponseException;
import com.gradle.maven.extension.internal.dep.org.apache.http.ProtocolException;
import com.gradle.maven.extension.internal.dep.org.apache.http.StatusLine;
import com.gradle.maven.extension.internal.dep.org.apache.http.config.MessageConstraints;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.DefaultHttpResponseFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.io.AbstractMessageParser;
import com.gradle.maven.extension.internal.dep.org.apache.http.io.SessionInputBuffer;
import com.gradle.maven.extension.internal.dep.org.apache.http.message.LineParser;
import com.gradle.maven.extension.internal.dep.org.apache.http.message.ParserCursor;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.CharArrayBuffer;
import java.io.IOException;

public class DefaultHttpResponseParser
extends AbstractMessageParser<HttpResponse> {
    private final Log log = LogFactory.getLog(this.getClass());
    private final HttpResponseFactory responseFactory;
    private final CharArrayBuffer lineBuf;

    public DefaultHttpResponseParser(SessionInputBuffer sessionInputBuffer, LineParser lineParser, HttpResponseFactory httpResponseFactory, MessageConstraints messageConstraints) {
        super(sessionInputBuffer, lineParser, messageConstraints);
        this.responseFactory = httpResponseFactory != null ? httpResponseFactory : DefaultHttpResponseFactory.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    @Override
    protected HttpResponse parseHead(SessionInputBuffer sessionInputBuffer) throws IOException, HttpException {
        int n2 = 0;
        ParserCursor parserCursor = null;
        while (true) {
            this.lineBuf.clear();
            int n3 = sessionInputBuffer.readLine(this.lineBuf);
            if (n3 == -1 && n2 == 0) {
                throw new NoHttpResponseException("The target server failed to respond");
            }
            parserCursor = new ParserCursor(0, this.lineBuf.length());
            if (this.lineParser.hasProtocolVersion(this.lineBuf, parserCursor)) break;
            if (n3 == -1 || this.reject(this.lineBuf, n2)) {
                throw new ProtocolException("The server failed to respond with a valid HTTP response");
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Garbage in response: " + this.lineBuf.toString());
            }
            ++n2;
        }
        StatusLine statusLine = this.lineParser.parseStatusLine(this.lineBuf, parserCursor);
        return this.responseFactory.newHttpResponse(statusLine, null);
    }

    protected boolean reject(CharArrayBuffer charArrayBuffer, int n2) {
        return false;
    }
}

