/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.reflect;

import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.ArrayUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.ClassUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.Validate;
import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.reflect.MemberUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class MethodUtils {
    private static final Comparator<Method> METHOD_BY_SIGNATURE = Comparator.comparing(Method::toString);

    public static Object invokeMethod(Object object, boolean bl2, String string, Object ... objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        Class<?>[] classArray = ClassUtils.toClass(objectArray);
        return MethodUtils.invokeMethod(object, bl2, string, objectArray, classArray);
    }

    public static Object invokeMethod(Object object, boolean bl2, String string, Object[] objectArray, Class<?>[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String string2;
        classArray = ArrayUtils.nullToEmpty(classArray);
        objectArray = ArrayUtils.nullToEmpty(objectArray);
        Method method = null;
        if (bl2) {
            string2 = "No such method: ";
            method = MethodUtils.getMatchingMethod(object.getClass(), string, classArray);
            if (method != null && !method.isAccessible()) {
                method.setAccessible(true);
            }
        } else {
            string2 = "No such accessible method: ";
            method = MethodUtils.getMatchingAccessibleMethod(object.getClass(), string, classArray);
        }
        if (method == null) {
            throw new NoSuchMethodException(string2 + string + "() on object: " + object.getClass().getName());
        }
        objectArray = MethodUtils.toVarArgs(method, objectArray);
        return method.invoke(object, objectArray);
    }

    private static Object[] toVarArgs(Method method, Object[] objectArray) {
        if (method.isVarArgs()) {
            Class<?>[] classArray = method.getParameterTypes();
            objectArray = MethodUtils.getVarArgs(objectArray, classArray);
        }
        return objectArray;
    }

    static Object[] getVarArgs(Object[] objectArray, Class<?>[] classArray) {
        if (objectArray.length == classArray.length && (objectArray[objectArray.length - 1] == null || objectArray[objectArray.length - 1].getClass().equals(classArray[classArray.length - 1]))) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[classArray.length];
        System.arraycopy(objectArray, 0, objectArray2, 0, classArray.length - 1);
        Class<?> clazz = classArray[classArray.length - 1].getComponentType();
        int n2 = objectArray.length - classArray.length + 1;
        Object object = Array.newInstance(ClassUtils.primitiveToWrapper(clazz), n2);
        System.arraycopy(objectArray, classArray.length - 1, object, 0, n2);
        if (clazz.isPrimitive()) {
            object = ArrayUtils.toPrimitive(object);
        }
        objectArray2[classArray.length - 1] = object;
        return objectArray2;
    }

    public static Method getAccessibleMethod(Method method) {
        Class<?>[] classArray;
        if (!MemberUtils.isAccessible(method)) {
            return null;
        }
        Class<?> clazz = method.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return method;
        }
        String string = method.getName();
        if ((method = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz, string, classArray = method.getParameterTypes())) == null) {
            method = MethodUtils.getAccessibleMethodFromSuperclass(clazz, string, classArray);
        }
        return method;
    }

    private static Method getAccessibleMethodFromSuperclass(Class<?> clazz, String string, Class<?> ... classArray) {
        for (Class<?> clazz2 = clazz.getSuperclass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            if (!Modifier.isPublic(clazz2.getModifiers())) continue;
            try {
                return clazz2.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
        return null;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class<?> clazz, String string, Class<?> ... classArray) {
        while (clazz != null) {
            Class<?>[] classArray2;
            for (Class<?> clazz2 : classArray2 = clazz.getInterfaces()) {
                if (!Modifier.isPublic(clazz2.getModifiers())) continue;
                try {
                    return clazz2.getDeclaredMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Method method = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz2, string, classArray);
                    if (method == null) continue;
                    return method;
                }
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static Method getMatchingAccessibleMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        try {
            Method method = clazz.getMethod(string, classArray);
            MemberUtils.setAccessibleWorkaround(method);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Method[] methodArray = clazz.getMethods();
            ArrayList<Method> arrayList = new ArrayList<Method>();
            for (Method object2 : methodArray) {
                if (!object2.getName().equals(string) || !MemberUtils.isMatchingMethod(object2, classArray)) continue;
                arrayList.add(object2);
            }
            arrayList.sort(METHOD_BY_SIGNATURE);
            Object object3 = null;
            for (Method method : arrayList) {
                Method method2 = MethodUtils.getAccessibleMethod(method);
                if (method2 == null || object3 != null && MemberUtils.compareMethodFit(method2, (Method)object3, classArray) >= 0) continue;
                object3 = method2;
            }
            if (object3 != null) {
                MemberUtils.setAccessibleWorkaround((AccessibleObject)object3);
            }
            if (object3 != null && ((Method)object3).isVarArgs() && ((Method)object3).getParameterTypes().length > 0 && classArray.length > 0) {
                String string2;
                Class<?>[] classArray2 = ((Method)object3).getParameterTypes();
                Class<?> clazz2 = classArray2[classArray2.length - 1].getComponentType();
                String string3 = ClassUtils.primitiveToWrapper(clazz2).getName();
                Class<?> clazz3 = classArray[classArray.length - 1];
                String string4 = clazz3 == null ? null : clazz3.getName();
                String string5 = string2 = clazz3 == null ? null : clazz3.getSuperclass().getName();
                if (string4 != null && string2 != null && !string3.equals(string4) && !string3.equals(string2)) {
                    return null;
                }
            }
            return object3;
        }
    }

    public static Method getMatchingMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        Validate.notNull(clazz, "Null class not allowed.", new Object[0]);
        Validate.notEmpty(string, "Null or blank methodName not allowed.", new Object[0]);
        Method[] methodArray = clazz.getDeclaredMethods();
        List<Class<?>> list = ClassUtils.getAllSuperclasses(clazz);
        for (Class<?> methodArray2 : list) {
            methodArray = ArrayUtils.addAll(methodArray, methodArray2.getDeclaredMethods());
        }
        Object object = null;
        for (Method method : methodArray) {
            if (string.equals(method.getName()) && Objects.deepEquals(classArray, method.getParameterTypes())) {
                return method;
            }
            if (!string.equals(method.getName()) || !ClassUtils.isAssignable(classArray, method.getParameterTypes(), true) || object != null && MethodUtils.distance(classArray, method.getParameterTypes()) >= MethodUtils.distance(classArray, ((Method)object).getParameterTypes())) continue;
            object = method;
        }
        return object;
    }

    private static int distance(Class<?>[] classArray, Class<?>[] classArray2) {
        int n2 = 0;
        if (!ClassUtils.isAssignable(classArray, classArray2, true)) {
            return -1;
        }
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            if (classArray[i2].equals(classArray2[i2])) continue;
            if (ClassUtils.isAssignable(classArray[i2], classArray2[i2], true) && !ClassUtils.isAssignable(classArray[i2], classArray2[i2], false)) {
                ++n2;
                continue;
            }
            n2 += 2;
        }
        return n2;
    }
}

