/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.datetime;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.datetime.AbstractCalendarFormatter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.datetime.BigDateTimeValueType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.datetime.IDateTimeValueType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;

public class PreciseCalendarFormatter
extends AbstractCalendarFormatter {
    private static final PreciseCalendarFormatter theInstance = new PreciseCalendarFormatter();

    private PreciseCalendarFormatter() {
    }

    public static String format(String string, IDateTimeValueType iDateTimeValueType) {
        return theInstance.doFormat(string, iDateTimeValueType.getBigValue());
    }

    protected Calendar toCalendar(Object object) {
        return ((BigDateTimeValueType)object).toCalendar();
    }

    protected void formatYear(Object object, StringBuffer stringBuffer) {
        String string;
        BigDateTimeValueType bigDateTimeValueType = ((IDateTimeValueType)object).getBigValue();
        BigInteger bigInteger = bigDateTimeValueType.getYear();
        if (bigInteger == null) {
            stringBuffer.append("0000");
            return;
        }
        if (bigInteger.signum() <= 0) {
            stringBuffer.append('-');
            string = bigInteger.negate().add(BigInteger.ONE).toString();
        } else {
            string = bigInteger.toString();
        }
        while (string.length() < 4) {
            string = "0" + string;
        }
        stringBuffer.append(string);
    }

    protected void formatMonth(Object object, StringBuffer stringBuffer) {
        BigDateTimeValueType bigDateTimeValueType = ((IDateTimeValueType)object).getBigValue();
        this.formatTwoDigits(bigDateTimeValueType.getMonth(), 1, stringBuffer);
    }

    protected void formatDays(Object object, StringBuffer stringBuffer) {
        BigDateTimeValueType bigDateTimeValueType = ((IDateTimeValueType)object).getBigValue();
        this.formatTwoDigits(bigDateTimeValueType.getDay(), 1, stringBuffer);
    }

    protected void formatHours(Object object, StringBuffer stringBuffer) {
        BigDateTimeValueType bigDateTimeValueType = ((IDateTimeValueType)object).getBigValue();
        this.formatTwoDigits(bigDateTimeValueType.getHour(), stringBuffer);
    }

    protected void formatMinutes(Object object, StringBuffer stringBuffer) {
        BigDateTimeValueType bigDateTimeValueType = ((IDateTimeValueType)object).getBigValue();
        this.formatTwoDigits(bigDateTimeValueType.getMinute(), stringBuffer);
    }

    protected void formatSeconds(Object object, StringBuffer stringBuffer) {
        BigDateTimeValueType bigDateTimeValueType = ((IDateTimeValueType)object).getBigValue();
        BigDecimal bigDecimal = bigDateTimeValueType.getSecond();
        if (bigDecimal == null) {
            stringBuffer.append("00");
            return;
        }
        while (bigDecimal.scale() > 0 && bigDecimal.toString().endsWith("0")) {
            bigDecimal = bigDecimal.movePointLeft(1);
        }
        String string = bigDecimal.toString();
        if (bigDecimal.compareTo(new BigDecimal("10")) < 0) {
            string = "0" + string;
        }
        stringBuffer.append(string);
    }

    private void formatTwoDigits(Integer n2, StringBuffer stringBuffer) {
        this.formatTwoDigits(n2, 0, stringBuffer);
    }

    private void formatTwoDigits(Integer n2, int n3, StringBuffer stringBuffer) {
        if (n2 == null) {
            stringBuffer.append("00");
        } else {
            this.formatTwoDigits(n2 + n3, stringBuffer);
        }
    }
}

