/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.org_isorelax.verifier.impl;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.org_isorelax.verifier.Verifier;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.org_isorelax.verifier.VerifierConfigurationException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.org_isorelax.verifier.VerifierFilter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.org_isorelax.verifier.VerifierHandler;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.org_isorelax.verifier.impl.SAXEventGenerator;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.org_isorelax.verifier.impl.VerifierFilterImpl;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public abstract class VerifierImpl
implements Verifier {
    protected XMLReader reader;
    protected ErrorHandler errorHandler = new ErrorHandler(){

        public void warning(SAXParseException sAXParseException) {
        }

        public void error(SAXParseException sAXParseException) {
        }

        public void fatalError(SAXParseException sAXParseException) {
        }
    };
    protected EntityResolver entityResolver;
    private VerifierFilter filter;

    protected VerifierImpl() throws VerifierConfigurationException {
        this.prepareXMLReader();
    }

    protected void prepareXMLReader() throws VerifierConfigurationException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            this.reader = sAXParserFactory.newSAXParser().getXMLReader();
        }
        catch (SAXException sAXException) {
            throw new VerifierConfigurationException(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new VerifierConfigurationException(parserConfigurationException);
        }
    }

    public boolean isFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://www.iso-relax.org/verifier/handler".equals(string) || "http://www.iso-relax.org/verifier/filter".equals(string)) {
            return true;
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setFeature(String string, boolean bl2) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(string);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(string);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public boolean verify(String string) throws SAXException, IOException {
        return this.verify(new InputSource(string));
    }

    public boolean verify(InputSource inputSource) throws SAXException, IOException {
        VerifierHandler verifierHandler = this.getVerifierHandler();
        this.reader.setErrorHandler(this.errorHandler);
        if (this.entityResolver != null) {
            this.reader.setEntityResolver(this.entityResolver);
        }
        this.reader.setContentHandler(verifierHandler);
        this.reader.parse(inputSource);
        return verifierHandler.isValid();
    }

    public boolean verify(File file) throws SAXException, IOException {
        String string = "file:" + file.getAbsolutePath();
        if (File.separatorChar == '\\') {
            string = string.replace('\\', '/');
        }
        return this.verify(new InputSource(string));
    }

    public boolean verify(Node node) throws SAXException {
        SAXEventGenerator sAXEventGenerator = new SAXEventGenerator(node);
        sAXEventGenerator.setDocumentEmulation(true);
        sAXEventGenerator.setErrorHandler(this.errorHandler);
        VerifierHandler verifierHandler = this.getVerifierHandler();
        sAXEventGenerator.makeEvent(verifierHandler);
        return verifierHandler.isValid();
    }

    public abstract VerifierHandler getVerifierHandler() throws SAXException;

    public VerifierFilter getVerifierFilter() throws SAXException {
        if (this.filter == null) {
            this.filter = new VerifierFilterImpl(this);
        }
        return this.filter;
    }
}

