/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.atomic.AtomicLong;

public interface DirectorySnapshotterStatistics {

    public static abstract class CollectingFileVisitor
    implements FileVisitor<Path> {
        protected final Collector collector;

        public CollectingFileVisitor(Collector collector) {
            this.collector = collector;
            collector.recordVisitHierarchy();
        }

        @Override
        public final FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) {
            this.collector.recordVisitDirectory();
            return this.doPreVisitDirectory(path, basicFileAttributes);
        }

        protected abstract FileVisitResult doPreVisitDirectory(Path var1, BasicFileAttributes var2);

        @Override
        public final FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
            this.collector.recordVisitFile();
            return this.doVisitFile(path, basicFileAttributes);
        }

        protected abstract FileVisitResult doVisitFile(Path var1, BasicFileAttributes var2);

        @Override
        public final FileVisitResult visitFileFailed(Path path, IOException iOException) {
            this.collector.recordVisitFileFailed();
            return this.doVisitFileFailed(path, iOException);
        }

        protected abstract FileVisitResult doVisitFileFailed(Path var1, IOException var2);

        @Override
        public final FileVisitResult postVisitDirectory(Path path, IOException iOException) {
            return this.doPostVisitDirectory(path, iOException);
        }

        protected abstract FileVisitResult doPostVisitDirectory(Path var1, IOException var2);
    }

    public static class Collector {
        private final AtomicLong hierarchyCount = new AtomicLong();
        private final AtomicLong directoryCount = new AtomicLong();
        private final AtomicLong fileCount = new AtomicLong();
        private final AtomicLong failedFileCount = new AtomicLong();

        public void recordVisitHierarchy() {
            this.hierarchyCount.incrementAndGet();
        }

        public void recordVisitDirectory() {
            this.directoryCount.incrementAndGet();
        }

        public void recordVisitFile() {
            this.fileCount.incrementAndGet();
        }

        public void recordVisitFileFailed() {
            this.failedFileCount.incrementAndGet();
        }
    }
}

