/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import java.io.File;
import java.util.Comparator;
import org.gradle.internal.snapshot.CaseSensitivity;

public class PathUtil {
    private static final char SYSTEM_SEPARATOR = File.separatorChar;
    private static final boolean IS_WINDOWS_SEPARATOR = SYSTEM_SEPARATOR == '\\';
    private static final char OTHER_SEPARATOR = (char)(IS_WINDOWS_SEPARATOR ? 47 : 92);
    private static final Comparator<String> CASE_SENSITIVE_COMPARATOR = (string, string2) -> PathUtil.comparePaths(string, string2, CaseSensitivity.CASE_SENSITIVE);
    private static final Comparator<String> CASE_INSENSITIVE_COMPARATOR = (string, string2) -> PathUtil.comparePaths(string, string2, CaseSensitivity.CASE_INSENSITIVE);

    public static boolean isFileSeparator(char c2) {
        return c2 == SYSTEM_SEPARATOR || c2 == OTHER_SEPARATOR;
    }

    public static int compareFileNames(String string, String string2) {
        int n2 = string.compareToIgnoreCase(string2);
        return n2 != 0 ? n2 : string.compareTo(string2);
    }

    static int compareCharsIgnoringCase(char c2, char c3) {
        if (c2 == c3) {
            return 0;
        }
        return PathUtil.isFileSeparator(c2) ? (PathUtil.isFileSeparator(c3) ? 0 : -1) : (PathUtil.isFileSeparator(c3) ? 1 : PathUtil.compareDifferentCharsIgnoringCase(c2, c3));
    }

    private static int compareDifferentCharsIgnoringCase(char c2, char c3) {
        char c4;
        char c5 = Character.toUpperCase(c2);
        if (c5 != (c4 = Character.toUpperCase(c3)) && (c5 = Character.toLowerCase(c5)) != (c4 = Character.toLowerCase(c4))) {
            return Character.compare(c5, c4);
        }
        return 0;
    }

    static int compareChars(char c2, char c3) {
        if (c2 == c3) {
            return 0;
        }
        return PathUtil.isFileSeparator(c2) ? (PathUtil.isFileSeparator(c3) ? 0 : -1) : (PathUtil.isFileSeparator(c3) ? 1 : Character.compare(c2, c3));
    }

    private static int comparePaths(String string, String string2, CaseSensitivity caseSensitivity) {
        int n2;
        int n3 = Math.min(string.length(), string2.length());
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            char c2;
            char c3 = string.charAt(n2);
            int n5 = PathUtil.compareCharsIgnoringCase(c3, c2 = string2.charAt(n2));
            if (n5 != 0) {
                return n5;
            }
            if ((n4 = PathUtil.computeCombinedCompare(n4, c3, c2, caseSensitivity == CaseSensitivity.CASE_SENSITIVE)) == 0 || !PathUtil.isFileSeparator(c3)) continue;
            return n4;
        }
        n2 = Integer.compare(string.length(), string2.length());
        return n2 != 0 ? n2 : n4;
    }

    private static int computeCombinedCompare(int n2, char c2, char c3, boolean bl2) {
        if (!bl2) {
            return 0;
        }
        return n2 == 0 ? PathUtil.compareChars(c2, c3) : n2;
    }

    public static String getFileName(String string) {
        int n2 = PathUtil.lastIndexOfSeparator(string);
        return n2 < 0 ? string : string.substring(n2 + 1);
    }

    private static int lastIndexOfSeparator(String string) {
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            char c2 = string.charAt(i2);
            if (!PathUtil.isFileSeparator(c2)) continue;
            return i2;
        }
        return -1;
    }
}

