/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.BuildOperationListenerManager;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;

public class DefaultBuildOperationListenerManager
implements BuildOperationListenerManager {
    private final AtomicReference<ImmutableList<ProgressShieldingBuildOperationListener>> listeners = new AtomicReference(ImmutableList.of());
    private final BuildOperationListener broadcaster = new BuildOperationListener(){

        @Override
        public void started(BuildOperationDescriptor buildOperationDescriptor, OperationStartEvent operationStartEvent) {
            ImmutableList immutableList = DefaultBuildOperationListenerManager.this.getListeners();
            for (int i2 = 0; i2 < immutableList.size(); ++i2) {
                ((BuildOperationListener)immutableList.get(i2)).started(buildOperationDescriptor, operationStartEvent);
            }
        }

        @Override
        public void progress(OperationIdentifier operationIdentifier, OperationProgressEvent operationProgressEvent) {
            ImmutableList immutableList = DefaultBuildOperationListenerManager.this.getListeners();
            for (int i2 = 0; i2 < immutableList.size(); ++i2) {
                ((BuildOperationListener)immutableList.get(i2)).progress(operationIdentifier, operationProgressEvent);
            }
        }

        @Override
        public void finished(BuildOperationDescriptor buildOperationDescriptor, OperationFinishEvent operationFinishEvent) {
            ImmutableList immutableList = DefaultBuildOperationListenerManager.this.getListeners();
            for (int i2 = immutableList.size() - 1; i2 >= 0; --i2) {
                ((BuildOperationListener)immutableList.get(i2)).finished(buildOperationDescriptor, operationFinishEvent);
            }
        }
    };

    private ImmutableList<ProgressShieldingBuildOperationListener> getListeners() {
        return this.listeners.get();
    }

    @Override
    public void addListener(BuildOperationListener buildOperationListener) {
        this.listeners.updateAndGet(immutableList -> ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builderWithExpectedSize(immutableList.size() + 1).addAll((Iterable)immutableList)).add(new ProgressShieldingBuildOperationListener(buildOperationListener))).build());
    }

    @Override
    public void removeListener(BuildOperationListener buildOperationListener) {
        this.listeners.updateAndGet(immutableList -> immutableList.stream().filter(progressShieldingBuildOperationListener -> !((ProgressShieldingBuildOperationListener)progressShieldingBuildOperationListener).delegate.equals(buildOperationListener)).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public BuildOperationListener getBroadcaster() {
        return this.broadcaster;
    }

    private static class ProgressShieldingBuildOperationListener
    implements BuildOperationListener {
        private final Map<OperationIdentifier, Boolean> active = new ConcurrentHashMap<OperationIdentifier, Boolean>();
        private final BuildOperationListener delegate;

        private ProgressShieldingBuildOperationListener(BuildOperationListener buildOperationListener) {
            this.delegate = buildOperationListener;
        }

        @Override
        public void started(BuildOperationDescriptor buildOperationDescriptor, OperationStartEvent operationStartEvent) {
            this.active.put(buildOperationDescriptor.getId(), Boolean.TRUE);
            this.delegate.started(buildOperationDescriptor, operationStartEvent);
        }

        @Override
        public void progress(OperationIdentifier operationIdentifier, OperationProgressEvent operationProgressEvent) {
            if (this.active.containsKey(operationIdentifier)) {
                this.delegate.progress(operationIdentifier, operationProgressEvent);
            }
        }

        @Override
        public void finished(BuildOperationDescriptor buildOperationDescriptor, OperationFinishEvent operationFinishEvent) {
            this.active.remove(buildOperationDescriptor.getId());
            this.delegate.finished(buildOperationDescriptor, operationFinishEvent);
        }
    }
}

