/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint;

import java.util.function.Predicate;
import org.gradle.internal.file.FileType;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;

public enum DirectorySensitivity {
    DEFAULT(fileSystemLocationSnapshot -> true),
    IGNORE_DIRECTORIES(fileSystemLocationSnapshot -> fileSystemLocationSnapshot.getType() != FileType.Directory);

    private final Predicate<FileSystemLocationSnapshot> fingerprintCheck;

    private DirectorySensitivity(Predicate<FileSystemLocationSnapshot> predicate) {
        this.fingerprintCheck = predicate;
    }

    public boolean shouldFingerprint(FileSystemLocationSnapshot fileSystemLocationSnapshot) {
        return this.fingerprintCheck.test(fileSystemLocationSnapshot);
    }
}

