/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.packaging.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.origin.OriginReader;
import org.gradle.caching.internal.origin.OriginWriter;
import org.gradle.caching.internal.packaging.BuildCacheEntryPacker;
import org.gradle.internal.snapshot.FileSystemSnapshot;

public class GZipBuildCacheEntryPacker
implements BuildCacheEntryPacker {
    private final BuildCacheEntryPacker delegate;

    public GZipBuildCacheEntryPacker(BuildCacheEntryPacker buildCacheEntryPacker) {
        this.delegate = buildCacheEntryPacker;
    }

    @Override
    public BuildCacheEntryPacker.PackResult pack(CacheableEntity cacheableEntity, Map<String, ? extends FileSystemSnapshot> map, OutputStream outputStream, OriginWriter originWriter) throws IOException {
        try (GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(outputStream);){
            BuildCacheEntryPacker.PackResult packResult = this.delegate.pack(cacheableEntity, map, gZIPOutputStream, originWriter);
            return packResult;
        }
    }

    @Override
    public BuildCacheEntryPacker.UnpackResult unpack(CacheableEntity cacheableEntity, InputStream inputStream, OriginReader originReader) throws IOException {
        try (GZIPInputStream gZIPInputStream = new GZIPInputStream(inputStream);){
            BuildCacheEntryPacker.UnpackResult unpackResult = this.delegate.unpack(cacheableEntity, gZIPInputStream, originReader);
            return unpackResult;
        }
    }
}

