/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.cacheops;

import org.gradle.cache.internal.cacheops.CacheOperationStack;

public class CacheAccessOperationsStack {
    private final ThreadLocal<CacheOperationStack> stackForThread = new ThreadLocal();

    public void pushCacheAction() {
        CacheOperationStack cacheOperationStack = this.getOrCreateStack();
        cacheOperationStack.pushCacheAction();
    }

    public void popCacheAction() {
        CacheOperationStack cacheOperationStack = this.stackForThread.get();
        if (cacheOperationStack == null) {
            throw new IllegalStateException("Operation stack is empty.");
        }
        cacheOperationStack.popCacheAction();
        if (cacheOperationStack.isEmpty()) {
            this.stackForThread.remove();
        }
    }

    public boolean isInCacheAction() {
        CacheOperationStack cacheOperationStack = this.stackForThread.get();
        return cacheOperationStack != null && cacheOperationStack.isInCacheAction();
    }

    private CacheOperationStack getOrCreateStack() {
        CacheOperationStack cacheOperationStack = this.stackForThread.get();
        if (cacheOperationStack == null) {
            cacheOperationStack = new CacheOperationStack();
            this.stackForThread.set(cacheOperationStack);
        }
        return cacheOperationStack;
    }
}

