/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import org.gradle.cache.CleanupProgressMonitor;
import org.gradle.internal.operations.BuildOperationContext;

public class DefaultCleanupProgressMonitor
implements CleanupProgressMonitor {
    private final BuildOperationContext buildOperationContext;
    private long deleted;
    private long skipped;

    public DefaultCleanupProgressMonitor(BuildOperationContext buildOperationContext) {
        this.buildOperationContext = buildOperationContext;
    }

    @Override
    public void incrementDeleted() {
        ++this.deleted;
        this.updateProgress();
    }

    @Override
    public void incrementSkipped() {
        this.incrementSkipped(1L);
    }

    public void incrementSkipped(long l2) {
        this.skipped += l2;
        this.updateProgress();
    }

    public long getDeleted() {
        return this.deleted;
    }

    private void updateProgress() {
        this.buildOperationContext.progress(DefaultCleanupProgressMonitor.mandatoryNumber(this.deleted, " entry", " entries") + " deleted" + DefaultCleanupProgressMonitor.optionalNumber(", ", this.skipped, " skipped"));
    }

    private static String mandatoryNumber(long l2, String string, String string2) {
        return l2 == 1L ? l2 + string : l2 + string2;
    }

    private static String optionalNumber(String string, long l2, String string2) {
        return l2 == 0L ? "" : string + l2 + string2;
    }
}

