/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.pattern;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.internal.file.pattern.PatternStep;

public class RegExpPatternStep
implements PatternStep {
    private final Pattern pattern;

    public RegExpPatternStep(String string, boolean bl2) {
        this.pattern = Pattern.compile(RegExpPatternStep.getRegExPattern(string), bl2 ? 0 : 2);
    }

    public String toString() {
        return "{regexp: " + this.pattern + "}";
    }

    protected static String getRegExPattern(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '*') {
                stringBuilder.append(".*");
                continue;
            }
            if (c2 == '?') {
                stringBuilder.append(".");
                continue;
            }
            if ("\\[]^-&.{}()$+|<=!".indexOf(c2) >= 0) {
                stringBuilder.append('\\');
                stringBuilder.append(c2);
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean matches(String string) {
        Matcher matcher = this.pattern.matcher(string);
        return matcher.matches();
    }
}

