/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.function.Supplier;
import org.gradle.api.internal.changedetection.state.DefaultZipEntryContext;
import org.gradle.api.internal.file.archive.ZipEntry;
import org.gradle.internal.fingerprint.hashing.RegularFileSnapshotContext;
import org.gradle.internal.fingerprint.hashing.ResourceHasher;
import org.gradle.internal.fingerprint.hashing.ZipEntryContext;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.io.IoSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class FallbackHandlingResourceHasher
implements ResourceHasher {
    private static final Logger LOGGER = LoggerFactory.getLogger(FallbackHandlingResourceHasher.class);
    private final ResourceHasher delegate;

    public FallbackHandlingResourceHasher(ResourceHasher resourceHasher) {
        this.delegate = resourceHasher;
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        this.delegate.appendConfigurationToHasher(hasher);
        hasher.putString(this.getClass().getName());
    }

    @Override
    public HashCode hash(RegularFileSnapshotContext regularFileSnapshotContext) throws IOException {
        return Optional.of(regularFileSnapshotContext).filter(this::filter).flatMap(regularFileSnapshotContext2 -> this.tryHash(regularFileSnapshotContext)).orElseGet(IoSupplier.wrap(() -> this.delegate.hash(regularFileSnapshotContext)));
    }

    @Override
    public HashCode hash(ZipEntryContext zipEntryContext) throws IOException {
        return Optional.of(zipEntryContext).filter(this::filter).flatMap(FallbackHandlingResourceHasher::withFallbackSafety).map(this::hashSafely).orElse(this.hashWithDelegate(zipEntryContext)).get();
    }

    private Supplier<HashCode> hashSafely(ZipEntryContext zipEntryContext) {
        return IoSupplier.wrap(() -> this.tryHash(zipEntryContext).orElseGet(this.hashWithDelegate(zipEntryContext)));
    }

    private Supplier<HashCode> hashWithDelegate(ZipEntryContext zipEntryContext) {
        return IoSupplier.wrap(() -> this.delegate.hash(zipEntryContext));
    }

    private static Optional<ZipEntryContext> withFallbackSafety(ZipEntryContext zipEntryContext) {
        ZipEntry zipEntry = zipEntryContext.getEntry();
        if (zipEntry.canReopen()) {
            return Optional.of(zipEntryContext);
        }
        if (zipEntry.size() > 0xA00000) {
            LOGGER.debug(zipEntryContext.getFullName() + " is too large (" + zipEntry.size() + ") for safe fallback - skipping.");
            return Optional.empty();
        }
        return Optional.of(new DefaultZipEntryContext(new CachingZipEntry(zipEntry), zipEntryContext.getFullName(), zipEntryContext.getRootParentName()));
    }

    abstract boolean filter(RegularFileSnapshotContext var1);

    abstract boolean filter(ZipEntryContext var1);

    abstract Optional<HashCode> tryHash(RegularFileSnapshotContext var1);

    abstract Optional<HashCode> tryHash(ZipEntryContext var1);

    private static class CachingZipEntry
    implements ZipEntry {
        private final ZipEntry delegate;
        private byte[] content;

        public CachingZipEntry(ZipEntry zipEntry) {
            this.delegate = zipEntry;
        }

        @Override
        public boolean isDirectory() {
            return this.delegate.isDirectory();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public byte[] getContent() throws IOException {
            if (this.content == null) {
                this.content = this.delegate.getContent();
            }
            return this.content;
        }

        @Override
        public <T> T withInputStream(ZipEntry.IoFunction<InputStream, T> ioFunction) throws IOException {
            return ioFunction.apply(new ByteArrayInputStream(this.getContent()));
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean canReopen() {
            return true;
        }
    }
}

