/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.mojo;

import com.gradle.enterprise.version.buildagent.BuildAgentToolVersion;
import com.gradle.enterprise.version.buildagent.b;
import com.gradle.maven.common.d;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.stax.WstxInputFactory;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.stax.WstxOutputFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonCreator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonRootName;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.gradle.nullability.Nullable;
import com.gradle.scan.plugin.internal.meta.CurrentBuildAgentVersion;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.rtinfo.RuntimeInformation;

@Named(value="develocity-init-mojo")
@javax.inject.Named(value="develocity-init-mojo")
public class InitMojo
extends AbstractMojo {
    @Nullable
    private URI url;
    private final RuntimeInformation runtimeInformation;
    private final MavenSession mavenSession;

    @com.google.inject.Inject
    @javax.inject.Inject
    @Inject
    public InitMojo(RuntimeInformation runtimeInformation, MavenSession mavenSession) {
        this.runtimeInformation = runtimeInformation;
        this.mavenSession = mavenSession;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkMavenVersion();
        Path path = this.getOrCreateMvnFolder();
        if (InitMojo.updateMavenExtensionsFile(path, this.getLog())) {
            this.updateDevelocityConfigurationFile(path);
            this.updateGitIgnore();
        }
    }

    private void checkMavenVersion() throws MojoFailureException {
        BuildAgentToolVersion buildAgentToolVersion = BuildAgentToolVersion.b(b.parse(this.runtimeInformation.getMavenVersion()), CurrentBuildAgentVersion.get());
        if (d.a(buildAgentToolVersion.toolVersion)) {
            String string = String.join((CharSequence)" ", d.a(buildAgentToolVersion.agentVersion, buildAgentToolVersion.toolVersion));
            throw new MojoFailureException(string);
        }
    }

    private Path getOrCreateMvnFolder() throws MojoFailureException {
        try {
            File file = this.mavenSession.getTopLevelProject().getBasedir();
            Path path = file.toPath().resolve(".mvn");
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectory(path, new FileAttribute[0]);
            }
            return path;
        }
        catch (IOException iOException) {
            throw new MojoFailureException("Failed creating .mvn folder", (Throwable)iOException);
        }
    }

    private static boolean updateMavenExtensionsFile(Path path, Log log) throws MojoFailureException {
        try {
            return MavenExtensionsFileManager.load(path.resolve("extensions.xml"), log).insert(Objects.requireNonNull(CurrentBuildAgentVersion.get().asString()));
        }
        catch (IOException iOException) {
            throw new MojoFailureException("Failed loading extensions file", (Throwable)iOException);
        }
    }

    private void updateDevelocityConfigurationFile(Path path) throws MojoFailureException {
        DevelocityConfigurationManager.load(path.resolve("develocity.xml"), this.url).createDevelocityConfigurationFileIfNeeded();
    }

    private void updateGitIgnore() throws MojoFailureException {
        GitIgnoreManager.load(this.mavenSession.getTopLevelProject().getBasedir().toPath().resolve(".gitignore")).insertIgnoreInternalDir();
    }

    static class MavenExtensionsFileManager {
        private static final String GROUP_ID = "com.gradle";
        private static final String GE_ARTIFACT_ID = "gradle-enterprise-maven-extension";
        private static final String DV_ARTIFACT_ID = "develocity-maven-extension";
        private final Path extensionsPath;
        private final Log log;

        private MavenExtensionsFileManager(Path path, Log log) {
            this.extensionsPath = path;
            this.log = log;
        }

        static MavenExtensionsFileManager load(Path path, Log log) throws IOException {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.write(path, Collections.singleton("<?xml version=\"1.0\" encoding=\"UTF-8\"?><extensions></extensions>"), new OpenOption[0]);
            }
            return new MavenExtensionsFileManager(path, log);
        }

        boolean insert(String string) throws MojoFailureException {
            try {
                XmlMapper xmlMapper = new XmlMapper(new XmlFactory(new WstxInputFactory(), new WstxOutputFactory()));
                xmlMapper.enable(SerializationFeature.INDENT_OUTPUT);
                xmlMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                Extensions extensions = xmlMapper.readValue(this.extensionsPath.toFile(), Extensions.class);
                if (extensions.geOrDvExtensionExists()) {
                    this.log.info((CharSequence)("A Develocity Maven extension is already configured on this project in " + this.extensionsPath));
                    return false;
                }
                extensions.addExtension(Extension.develocityExtension(string));
                xmlMapper.writeValue(this.extensionsPath.toFile(), (Object)extensions);
                return true;
            }
            catch (IOException iOException) {
                throw new MojoFailureException("Failed inserting Develocity extension", (Throwable)iOException);
            }
        }

        @JacksonXmlRootElement(localName="extensions")
        @JsonRootName(value="extensions")
        static class Extensions {
            @JacksonXmlElementWrapper(useWrapping=false)
            @JacksonXmlProperty(localName="extension")
            private final List<Extension> extensions = new ArrayList<Extension>();

            Extensions() {
            }

            void addExtension(Extension extension) {
                this.extensions.add(extension);
            }

            boolean geOrDvExtensionExists() {
                return this.extensions.stream().anyMatch(extension -> (MavenExtensionsFileManager.GE_ARTIFACT_ID.equals(extension.artifactId) || MavenExtensionsFileManager.DV_ARTIFACT_ID.equals(extension.artifactId)) && MavenExtensionsFileManager.GROUP_ID.equals(extension.groupId));
            }
        }

        @JacksonXmlRootElement(localName="extension")
        static class Extension {
            @JacksonXmlProperty(localName="groupId")
            final String groupId;
            @JacksonXmlProperty(localName="artifactId")
            final String artifactId;
            @JacksonXmlProperty(localName="version")
            final String version;

            @JsonCreator
            public Extension(@JacksonXmlProperty(localName="groupId") String string, @JacksonXmlProperty(localName="artifactId") String string2, @JacksonXmlProperty(localName="version") String string3) {
                this.groupId = string;
                this.artifactId = string2;
                this.version = string3;
            }

            static Extension develocityExtension(String string) {
                return new Extension(MavenExtensionsFileManager.GROUP_ID, MavenExtensionsFileManager.DV_ARTIFACT_ID, string);
            }
        }
    }

    static class DevelocityConfigurationManager {
        private static final String CONFIG = "<develocity>\n  <server>\n    <url>%s</url>\n  </server>\n</develocity>";
        private final Path develocityConfiguration;
        @Nullable
        private final URI geUrl;

        private DevelocityConfigurationManager(Path path, @Nullable URI uRI) {
            this.develocityConfiguration = path;
            this.geUrl = uRI;
        }

        static DevelocityConfigurationManager load(Path path, @Nullable URI uRI) {
            return new DevelocityConfigurationManager(path, uRI);
        }

        void createDevelocityConfigurationFileIfNeeded() throws MojoFailureException {
            try {
                if (this.geUrl != null && !Files.exists(this.develocityConfiguration, new LinkOption[0])) {
                    Files.write(this.develocityConfiguration, String.format(CONFIG, this.geUrl).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
            }
            catch (IOException iOException) {
                throw new MojoFailureException("Failed to create Gradle configuration file", (Throwable)iOException);
            }
        }
    }

    static class GitIgnoreManager {
        private final Path gitIgnore;

        private GitIgnoreManager(Path path) {
            this.gitIgnore = path;
        }

        static GitIgnoreManager load(Path path) {
            return new GitIgnoreManager(path);
        }

        void insertIgnoreInternalDir() throws MojoFailureException {
            try {
                if (!Files.exists(this.gitIgnore, new LinkOption[0])) {
                    Files.createFile(this.gitIgnore, new FileAttribute[0]);
                }
                String string = ".mvn/.develocity/";
                String string2 = new String(Files.readAllBytes(this.gitIgnore), StandardCharsets.UTF_8);
                if (!string2.contains(string)) {
                    String string3 = string2.isEmpty() ? string : (string2.endsWith(System.lineSeparator()) ? string + System.lineSeparator() : System.lineSeparator() + string + System.lineSeparator());
                    Files.write(this.gitIgnore, string3.getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                }
            }
            catch (IOException iOException) {
                throw new MojoFailureException("Failed updating .gitignore", (Throwable)iOException);
            }
        }
    }
}

