/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.util.platform.windows;

import com.gradle.maven.extension.internal.dep.oshi.util.ParseUtil;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegistryUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RegistryUtil.class);
    private static final Advapi32 ADV = Advapi32.INSTANCE;

    private RegistryUtil() {
    }

    public static long getLongValue(WinReg.HKEY hKEY, String string, String string2, int n2) {
        Object object = RegistryUtil.getRegistryValueOrNull(hKEY, string, string2, n2);
        return RegistryUtil.registryValueToLong(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getRegistryValueOrNull(WinReg.HKEY hKEY, String string, String string2, int n2) {
        int n3;
        Object object;
        WinReg.HKEY hKEY2 = null;
        try {
            hKEY2 = Advapi32Util.registryGetKey(hKEY, string, 0x20019 | n2).getValue();
            Object object2 = Advapi32Util.registryGetValue(hKEY, string, string2);
            Object object3 = object = Objects.isNull(object2) ? null : object2;
        }
        catch (Win32Exception win32Exception) {
            int n4;
            try {
                LOG.trace("Unable to access " + string + " with flag " + n2 + ": " + win32Exception.getMessage());
                if (hKEY2 == null || (n4 = ADV.RegCloseKey(hKEY2)) == 0) return null;
            }
            catch (Throwable throwable) {
                int n5;
                if (hKEY2 == null || (n5 = ADV.RegCloseKey(hKEY2)) == 0) throw throwable;
                throw new Win32Exception(n5);
            }
            throw new Win32Exception(n4);
        }
        if (hKEY2 == null || (n3 = ADV.RegCloseKey(hKEY2)) == 0) return object;
        throw new Win32Exception(n3);
    }

    private static long registryValueToLong(Object object) {
        if (object == null) {
            return 0L;
        }
        long l2 = System.currentTimeMillis() / 1000L;
        long l3 = l2 - 946080000L;
        if (object instanceof Integer) {
            int n2 = (Integer)object;
            if ((long)n2 > l3 && (long)n2 < l2) {
                return (long)n2 * 1000L;
            }
            return n2;
        }
        if (object instanceof String) {
            String string = ((String)object).trim();
            long l4 = ParseUtil.parseDateToEpoch(string, "yyyyMMdd");
            if (l4 == 0L) {
                l4 = ParseUtil.parseDateToEpoch(string, "MM/dd/yyyy");
            }
            return l4;
        }
        return 0L;
    }

    public static String getStringValue(WinReg.HKEY hKEY, String string, String string2, int n2) {
        Object object = RegistryUtil.getRegistryValueOrNull(hKEY, string, string2, n2);
        return RegistryUtil.registryValueToString(object);
    }

    private static String registryValueToString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return ((String)object).trim();
        }
        if (object instanceof byte[]) {
            return ParseUtil.decodeBinaryToString((byte[])object);
        }
        return null;
    }
}

