/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.util.platform.unix.freebsd;

import com.gradle.maven.extension.internal.dep.oshi.jna.ByRef;
import com.gradle.maven.extension.internal.dep.oshi.jna.platform.unix.FreeBsdLibc;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.platform.unix.LibCAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BsdSysctlUtil {
    private static final Logger LOG = LoggerFactory.getLogger(BsdSysctlUtil.class);

    private BsdSysctlUtil() {
    }

    public static int sysctl(String string, int n2) {
        int n3 = FreeBsdLibc.INT_SIZE;
        try (Memory memory = new Memory(n3);){
            ByRef.CloseableSizeTByReference closeableSizeTByReference;
            block12: {
                closeableSizeTByReference = new ByRef.CloseableSizeTByReference((long)n3);
                try {
                    if (0 == FreeBsdLibc.INSTANCE.sysctlbyname(string, memory, closeableSizeTByReference, null, LibCAPI.size_t.ZERO)) break block12;
                    LOG.warn("Failed sysctl call: {}, Error code: {}", (Object)string, (Object)Native.getLastError());
                    int n4 = n2;
                    closeableSizeTByReference.close();
                    return n4;
                }
                catch (Throwable throwable) {
                    try {
                        closeableSizeTByReference.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            int n5 = memory.getInt(0L);
            closeableSizeTByReference.close();
            return n5;
        }
    }

    public static long sysctl(String string, long l2) {
        int n2 = FreeBsdLibc.UINT64_SIZE;
        try (Memory memory = new Memory(n2);){
            ByRef.CloseableSizeTByReference closeableSizeTByReference;
            block12: {
                closeableSizeTByReference = new ByRef.CloseableSizeTByReference((long)n2);
                try {
                    if (0 == FreeBsdLibc.INSTANCE.sysctlbyname(string, memory, closeableSizeTByReference, null, LibCAPI.size_t.ZERO)) break block12;
                    LOG.warn("Failed sysctl call: {}, Error code: {}", (Object)string, (Object)Native.getLastError());
                    long l3 = l2;
                    closeableSizeTByReference.close();
                    return l3;
                }
                catch (Throwable throwable) {
                    try {
                        closeableSizeTByReference.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            long l4 = memory.getLong(0L);
            closeableSizeTByReference.close();
            return l4;
        }
    }

    public static String sysctl(String string, String string2) {
        try (ByRef.CloseableSizeTByReference closeableSizeTByReference = new ByRef.CloseableSizeTByReference();){
            Memory memory;
            block14: {
                if (0 != FreeBsdLibc.INSTANCE.sysctlbyname(string, null, closeableSizeTByReference, null, LibCAPI.size_t.ZERO)) {
                    LOG.warn("Failed sysctl call: {}, Error code: {}", (Object)string, (Object)Native.getLastError());
                    String string3 = string2;
                    return string3;
                }
                memory = new Memory(closeableSizeTByReference.longValue() + 1L);
                try {
                    if (0 == FreeBsdLibc.INSTANCE.sysctlbyname(string, memory, closeableSizeTByReference, null, LibCAPI.size_t.ZERO)) break block14;
                    LOG.warn("Failed sysctl call: {}, Error code: {}", (Object)string, (Object)Native.getLastError());
                    String string4 = string2;
                    memory.close();
                    return string4;
                }
                catch (Throwable throwable) {
                    try {
                        memory.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            String string5 = memory.getString(0L);
            memory.close();
            return string5;
        }
    }

    public static boolean sysctl(String string, Structure structure) {
        try (ByRef.CloseableSizeTByReference closeableSizeTByReference = new ByRef.CloseableSizeTByReference((long)structure.size());){
            if (0 != FreeBsdLibc.INSTANCE.sysctlbyname(string, structure.getPointer(), closeableSizeTByReference, null, LibCAPI.size_t.ZERO)) {
                LOG.error("Failed sysctl call: {}, Error code: {}", (Object)string, (Object)Native.getLastError());
                boolean bl2 = false;
                return bl2;
            }
        }
        structure.read();
        return true;
    }
}

