/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.hardware.platform.windows;

import com.gradle.maven.extension.internal.dep.oshi.driver.windows.wmi.MSAcpiThermalZoneTemperature;
import com.gradle.maven.extension.internal.dep.oshi.driver.windows.wmi.OhmHardware;
import com.gradle.maven.extension.internal.dep.oshi.driver.windows.wmi.OhmSensor;
import com.gradle.maven.extension.internal.dep.oshi.driver.windows.wmi.Win32Fan;
import com.gradle.maven.extension.internal.dep.oshi.driver.windows.wmi.Win32Processor;
import com.gradle.maven.extension.internal.dep.oshi.hardware.common.AbstractSensors;
import com.gradle.maven.extension.internal.dep.oshi.util.platform.windows.WmiQueryHandler;
import com.gradle.maven.extension.internal.dep.oshi.util.platform.windows.WmiUtil;
import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.WbemcliUtil;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WindowsSensors
extends AbstractSensors {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsSensors.class);

    WindowsSensors() {
    }

    @Override
    public double queryCpuTemperature() {
        double d2 = WindowsSensors.getTempFromOHM();
        if (d2 > 0.0) {
            return d2;
        }
        d2 = WindowsSensors.getTempFromLHM();
        if (d2 > 0.0) {
            return d2;
        }
        d2 = WindowsSensors.getTempFromWMI();
        return d2;
    }

    private static double getTempFromOHM() {
        WbemcliUtil.WmiResult<OhmSensor.ValueProperty> wmiResult2 = WindowsSensors.getOhmSensors("Hardware", "CPU", "Temperature", (wmiQueryHandler, wmiResult) -> {
            String string = WmiUtil.getString(wmiResult, OhmHardware.IdentifierProperty.IDENTIFIER, 0);
            if (!string.isEmpty()) {
                return OhmSensor.querySensorValue(wmiQueryHandler, string, "Temperature");
            }
            return null;
        });
        if (wmiResult2 != null && wmiResult2.getResultCount() > 0) {
            double d2 = 0.0;
            for (int i2 = 0; i2 < wmiResult2.getResultCount(); ++i2) {
                d2 += (double)WmiUtil.getFloat(wmiResult2, OhmSensor.ValueProperty.VALUE, i2);
            }
            return d2 / (double)wmiResult2.getResultCount();
        }
        return 0.0;
    }

    private static double getTempFromLHM() {
        return WindowsSensors.getAverageValueFromLHM("CPU", "Temperature", (string, d2) -> !string.contains("Max") && !string.contains("Average") && d2 > 0.0);
    }

    private static double getTempFromWMI() {
        double d2 = 0.0;
        long l2 = 0L;
        WbemcliUtil.WmiResult<MSAcpiThermalZoneTemperature.TemperatureProperty> wmiResult = MSAcpiThermalZoneTemperature.queryCurrentTemperature();
        if (wmiResult.getResultCount() > 0) {
            LOG.debug("Found Temperature data in WMI");
            l2 = WmiUtil.getUint32asLong(wmiResult, MSAcpiThermalZoneTemperature.TemperatureProperty.CURRENTTEMPERATURE, 0);
        }
        if (l2 > 2732L) {
            d2 = (double)l2 / 10.0 - 273.15;
        } else if (l2 > 274L) {
            d2 = (double)l2 - 273.0;
        }
        return Math.max(d2, 0.0);
    }

    @Override
    public int[] queryFanSpeeds() {
        int[] nArray = WindowsSensors.getFansFromOHM();
        if (nArray.length > 0) {
            return nArray;
        }
        nArray = WindowsSensors.getFansFromLHM();
        if (nArray.length > 0) {
            return nArray;
        }
        nArray = WindowsSensors.getFansFromWMI();
        if (nArray.length > 0) {
            return nArray;
        }
        return new int[0];
    }

    private static int[] getFansFromOHM() {
        WbemcliUtil.WmiResult<OhmSensor.ValueProperty> wmiResult2 = WindowsSensors.getOhmSensors("Hardware", "CPU", "Fan", (wmiQueryHandler, wmiResult) -> {
            String string = WmiUtil.getString(wmiResult, OhmHardware.IdentifierProperty.IDENTIFIER, 0);
            if (!string.isEmpty()) {
                return OhmSensor.querySensorValue(wmiQueryHandler, string, "Fan");
            }
            return null;
        });
        if (wmiResult2 != null && wmiResult2.getResultCount() > 0) {
            int[] nArray = new int[wmiResult2.getResultCount()];
            for (int i2 = 0; i2 < wmiResult2.getResultCount(); ++i2) {
                nArray[i2] = (int)WmiUtil.getFloat(wmiResult2, OhmSensor.ValueProperty.VALUE, i2);
            }
            return nArray;
        }
        return new int[0];
    }

    private static int[] getFansFromLHM() {
        List<?> list = WindowsSensors.getLhmSensors("SuperIO", "Fan");
        if (list == null || list.isEmpty()) {
            return new int[0];
        }
        try {
            Class<?> clazz = Class.forName("io.github.pandalxb.jlibrehardwaremonitor.model.Sensor");
            Method method = clazz.getMethod("getValue", new Class[0]);
            return list.stream().filter(object -> {
                try {
                    double d2 = (Double)method.invoke(object, new Object[0]);
                    return d2 > 0.0;
                }
                catch (Exception exception) {
                    LOG.warn("Reflect exception: {}", (Object)exception.getMessage());
                    return false;
                }
            }).mapToInt(object -> {
                try {
                    return (int)((Double)method.invoke(object, new Object[0])).doubleValue();
                }
                catch (Exception exception) {
                    LOG.warn("Reflect exception: {}", (Object)exception.getMessage());
                    return 0;
                }
            }).toArray();
        }
        catch (Exception exception) {
            LOG.warn("Reflect exception: {}", (Object)exception.getMessage());
            return new int[0];
        }
    }

    private static int[] getFansFromWMI() {
        WbemcliUtil.WmiResult<Win32Fan.SpeedProperty> wmiResult = Win32Fan.querySpeed();
        if (wmiResult.getResultCount() > 1) {
            LOG.debug("Found Fan data in WMI");
            int[] nArray = new int[wmiResult.getResultCount()];
            for (int i2 = 0; i2 < wmiResult.getResultCount(); ++i2) {
                nArray[i2] = (int)WmiUtil.getUint64(wmiResult, Win32Fan.SpeedProperty.DESIREDSPEED, i2);
            }
            return nArray;
        }
        return new int[0];
    }

    @Override
    public double queryCpuVoltage() {
        double d2 = WindowsSensors.getVoltsFromOHM();
        if (d2 > 0.0) {
            return d2;
        }
        d2 = WindowsSensors.getVoltsFromLHM();
        if (d2 > 0.0) {
            return d2;
        }
        d2 = WindowsSensors.getVoltsFromWMI();
        return d2;
    }

    private static double getVoltsFromOHM() {
        WbemcliUtil.WmiResult<OhmSensor.ValueProperty> wmiResult2 = WindowsSensors.getOhmSensors("Sensor", "Voltage", "Voltage", (wmiQueryHandler, wmiResult) -> {
            String string = null;
            for (int i2 = 0; i2 < wmiResult.getResultCount(); ++i2) {
                String string2 = WmiUtil.getString(wmiResult, OhmHardware.IdentifierProperty.IDENTIFIER, i2);
                if (!string2.toLowerCase(Locale.ROOT).contains("cpu")) continue;
                string = string2;
                break;
            }
            if (string == null) {
                string = WmiUtil.getString(wmiResult, OhmHardware.IdentifierProperty.IDENTIFIER, 0);
            }
            return OhmSensor.querySensorValue(wmiQueryHandler, string, "Voltage");
        });
        if (wmiResult2 != null && wmiResult2.getResultCount() > 0) {
            return WmiUtil.getFloat(wmiResult2, OhmSensor.ValueProperty.VALUE, 0);
        }
        return 0.0;
    }

    private static double getVoltsFromLHM() {
        return WindowsSensors.getAverageValueFromLHM("SuperIO", "Voltage", (string, d2) -> string.toLowerCase(Locale.ROOT).contains("vcore") && d2 > 0.0);
    }

    private static double getVoltsFromWMI() {
        WbemcliUtil.WmiResult<Win32Processor.VoltProperty> wmiResult = Win32Processor.queryVoltage();
        if (wmiResult.getResultCount() > 1) {
            LOG.debug("Found Voltage data in WMI");
            int n2 = WmiUtil.getUint16(wmiResult, Win32Processor.VoltProperty.CURRENTVOLTAGE, 0);
            if (n2 > 0) {
                if ((n2 & 0x80) == 0) {
                    n2 = WmiUtil.getUint32(wmiResult, Win32Processor.VoltProperty.VOLTAGECAPS, 0);
                    if ((n2 & 1) > 0) {
                        return 5.0;
                    }
                    if ((n2 & 2) > 0) {
                        return 3.3;
                    }
                    if ((n2 & 4) > 0) {
                        return 2.9;
                    }
                } else {
                    return (double)(n2 & 0x7F) / 10.0;
                }
            }
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WbemcliUtil.WmiResult<OhmSensor.ValueProperty> getOhmSensors(String string, String string2, String string3, BiFunction<WmiQueryHandler, WbemcliUtil.WmiResult<OhmHardware.IdentifierProperty>, WbemcliUtil.WmiResult<OhmSensor.ValueProperty>> biFunction) {
        WmiQueryHandler wmiQueryHandler = Objects.requireNonNull(WmiQueryHandler.createInstance());
        boolean bl2 = false;
        WbemcliUtil.WmiResult<OhmSensor.ValueProperty> wmiResult = null;
        try {
            bl2 = wmiQueryHandler.initCOM();
            WbemcliUtil.WmiResult<OhmHardware.IdentifierProperty> wmiResult2 = OhmHardware.queryHwIdentifier(wmiQueryHandler, string, string2);
            if (wmiResult2.getResultCount() > 0) {
                LOG.debug("Found {} data in Open Hardware Monitor", (Object)string3);
                wmiResult = biFunction.apply(wmiQueryHandler, wmiResult2);
            }
        }
        catch (COMException cOMException) {
            LOG.warn("COM exception: {}", (Object)cOMException.getMessage());
        }
        finally {
            if (bl2) {
                wmiQueryHandler.unInitCOM();
            }
        }
        return wmiResult;
    }

    private static double getAverageValueFromLHM(String string, String string2, BiFunction<String, Double, Boolean> biFunction) {
        List<?> list = WindowsSensors.getLhmSensors(string, string2);
        if (list == null || list.isEmpty()) {
            return 0.0;
        }
        try {
            Class<?> clazz = Class.forName("io.github.pandalxb.jlibrehardwaremonitor.model.Sensor");
            Method method = clazz.getMethod("getName", new Class[0]);
            Method method2 = clazz.getMethod("getValue", new Class[0]);
            double d2 = 0.0;
            int n2 = 0;
            for (Object obj : list) {
                double d3;
                String string3 = (String)method.invoke(obj, new Object[0]);
                if (!biFunction.apply(string3, d3 = ((Double)method2.invoke(obj, new Object[0])).doubleValue()).booleanValue()) continue;
                d2 += d3;
                ++n2;
            }
            return n2 > 0 ? d2 / (double)n2 : 0.0;
        }
        catch (Exception exception) {
            LOG.warn("Reflect exception: {}", (Object)exception.getMessage());
            return 0.0;
        }
    }

    private static List<?> getLhmSensors(String string, String string2) {
        try {
            Class<?> clazz = Class.forName("io.github.pandalxb.jlibrehardwaremonitor.config.ComputerConfig");
            Class<?> clazz2 = Class.forName("io.github.pandalxb.jlibrehardwaremonitor.manager.LibreHardwareManager");
            Method method = clazz.getMethod("getInstance", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            Method method2 = clazz.getMethod("setCpuEnabled", Boolean.TYPE);
            method2.invoke(object, true);
            method2 = clazz.getMethod("setMotherboardEnabled", Boolean.TYPE);
            method2.invoke(object, true);
            Method method3 = clazz2.getMethod("getInstance", clazz);
            Object object2 = method3.invoke(null, object);
            Method method4 = clazz2.getMethod("querySensors", String.class, String.class);
            return (List)method4.invoke(object2, string, string2);
        }
        catch (Exception exception) {
            LOG.warn("Reflect exception: {}", (Object)exception.getMessage());
            return Collections.emptyList();
        }
    }
}

