/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.hardware.platform.unix.freebsd;

import com.gradle.maven.extension.internal.dep.oshi.hardware.common.AbstractSensors;
import com.gradle.maven.extension.internal.dep.oshi.jna.ByRef;
import com.gradle.maven.extension.internal.dep.oshi.jna.platform.unix.FreeBsdLibc;
import com.sun.jna.Memory;
import com.sun.jna.platform.unix.LibCAPI;
import java.util.Locale;

final class FreeBsdSensors
extends AbstractSensors {
    FreeBsdSensors() {
    }

    @Override
    public double queryCpuTemperature() {
        return FreeBsdSensors.queryKldloadCoretemp();
    }

    private static double queryKldloadCoretemp() {
        String string = "dev.cpu.%d.temperature";
        try (ByRef.CloseableSizeTByReference closeableSizeTByReference = new ByRef.CloseableSizeTByReference((long)FreeBsdLibc.INT_SIZE);){
            int n2 = 0;
            double d2 = 0.0;
            try (Memory memory = new Memory(closeableSizeTByReference.longValue());){
                while (0 == FreeBsdLibc.INSTANCE.sysctlbyname(String.format(Locale.ROOT, string, n2), memory, closeableSizeTByReference, null, LibCAPI.size_t.ZERO)) {
                    d2 += (double)memory.getInt(0L) / 10.0 - 273.15;
                    ++n2;
                }
            }
            double d3 = n2 > 0 ? d2 / (double)n2 : Double.NaN;
            return d3;
        }
    }

    @Override
    public int[] queryFanSpeeds() {
        return new int[0];
    }

    @Override
    public double queryCpuVoltage() {
        return 0.0;
    }
}

