/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.hardware.platform.unix;

import com.gradle.maven.extension.internal.dep.oshi.hardware.NetworkIF;
import com.gradle.maven.extension.internal.dep.oshi.hardware.common.AbstractNetworkIF;
import com.gradle.maven.extension.internal.dep.oshi.util.ExecutingCommand;
import com.gradle.maven.extension.internal.dep.oshi.util.ParseUtil;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BsdNetworkIF
extends AbstractNetworkIF {
    private static final Logger LOG = LoggerFactory.getLogger(BsdNetworkIF.class);
    private long bytesRecv;
    private long bytesSent;
    private long packetsRecv;
    private long packetsSent;
    private long inErrors;
    private long outErrors;
    private long inDrops;
    private long collisions;
    private long timeStamp;

    public BsdNetworkIF(NetworkInterface networkInterface) throws InstantiationException {
        super(networkInterface);
        this.updateAttributes();
    }

    public static List<NetworkIF> getNetworks(boolean bl2) {
        ArrayList<NetworkIF> arrayList = new ArrayList<NetworkIF>();
        for (NetworkInterface networkInterface : BsdNetworkIF.getNetworkInterfaces(bl2)) {
            try {
                arrayList.add(new BsdNetworkIF(networkInterface));
            }
            catch (InstantiationException instantiationException) {
                LOG.debug("Network Interface Instantiation failed: {}", (Object)instantiationException.getMessage());
            }
        }
        return arrayList;
    }

    @Override
    public long getBytesRecv() {
        return this.bytesRecv;
    }

    @Override
    public long getBytesSent() {
        return this.bytesSent;
    }

    @Override
    public long getPacketsRecv() {
        return this.packetsRecv;
    }

    @Override
    public long getPacketsSent() {
        return this.packetsSent;
    }

    @Override
    public long getInErrors() {
        return this.inErrors;
    }

    @Override
    public long getOutErrors() {
        return this.outErrors;
    }

    @Override
    public long getInDrops() {
        return this.inDrops;
    }

    @Override
    public long getCollisions() {
        return this.collisions;
    }

    @Override
    public long getSpeed() {
        return 0L;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public boolean updateAttributes() {
        String string = ExecutingCommand.getAnswerAt("netstat -bI " + this.getName(), 1);
        this.timeStamp = System.currentTimeMillis();
        String[] stringArray = ParseUtil.whitespaces.split(string);
        if (stringArray.length < 12) {
            return false;
        }
        this.bytesSent = ParseUtil.parseUnsignedLongOrDefault(stringArray[10], 0L);
        this.bytesRecv = ParseUtil.parseUnsignedLongOrDefault(stringArray[7], 0L);
        this.packetsSent = ParseUtil.parseUnsignedLongOrDefault(stringArray[8], 0L);
        this.packetsRecv = ParseUtil.parseUnsignedLongOrDefault(stringArray[4], 0L);
        this.outErrors = ParseUtil.parseUnsignedLongOrDefault(stringArray[9], 0L);
        this.inErrors = ParseUtil.parseUnsignedLongOrDefault(stringArray[5], 0L);
        this.collisions = ParseUtil.parseUnsignedLongOrDefault(stringArray[11], 0L);
        this.inDrops = ParseUtil.parseUnsignedLongOrDefault(stringArray[6], 0L);
        return true;
    }
}

