/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.driver.windows.registry;

import com.gradle.maven.extension.internal.dep.oshi.software.os.ApplicationInfo;
import com.gradle.maven.extension.internal.dep.oshi.util.platform.windows.RegistryUtil;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public final class InstalledAppsData {
    private static final Map<WinReg.HKEY, List<String>> REGISTRY_PATHS = new HashMap<WinReg.HKEY, List<String>>();
    private static final int[] ACCESS_FLAGS = new int[]{256, 512};

    public static List<ApplicationInfo> queryInstalledApps() {
        LinkedHashSet<ApplicationInfo> linkedHashSet = new LinkedHashSet<ApplicationInfo>();
        for (Map.Entry<WinReg.HKEY, List<String>> entry : REGISTRY_PATHS.entrySet()) {
            WinReg.HKEY hKEY = entry.getKey();
            List<String> list = entry.getValue();
            for (String string : list) {
                for (int n2 : ACCESS_FLAGS) {
                    try {
                        String[] stringArray;
                        for (String string2 : stringArray = Advapi32Util.registryGetKeys(hKEY, string, n2)) {
                            String string3 = string + "\\" + string2;
                            try {
                                String string4 = RegistryUtil.getStringValue(hKEY, string3, "DisplayName", n2);
                                if (string4 == null) continue;
                                String string5 = RegistryUtil.getStringValue(hKEY, string3, "DisplayVersion", n2);
                                String string6 = RegistryUtil.getStringValue(hKEY, string3, "Publisher", n2);
                                long l2 = RegistryUtil.getLongValue(hKEY, string3, "InstallDate", n2);
                                String string7 = RegistryUtil.getStringValue(hKEY, string3, "InstallLocation", n2);
                                String string8 = RegistryUtil.getStringValue(hKEY, string3, "InstallSource", n2);
                                LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                                linkedHashMap.put("installLocation", string7);
                                linkedHashMap.put("installSource", string8);
                                ApplicationInfo applicationInfo = new ApplicationInfo(string4, string5, string6, l2, linkedHashMap);
                                linkedHashSet.add(applicationInfo);
                            }
                            catch (Win32Exception win32Exception) {
                                // empty catch block
                            }
                        }
                    }
                    catch (Win32Exception win32Exception) {
                        // empty catch block
                    }
                }
            }
        }
        return new ArrayList<ApplicationInfo>(linkedHashSet);
    }

    static {
        REGISTRY_PATHS.put(WinReg.HKEY_LOCAL_MACHINE, Arrays.asList("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall", "SOFTWARE\\WOW6432Node\\Microsoft\\Windows\\CurrentVersion\\Uninstall"));
        REGISTRY_PATHS.put(WinReg.HKEY_CURRENT_USER, Arrays.asList("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall"));
    }
}

