/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support;

import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypeComparator;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelMessage;
import com.gradle.maven.extension.internal.dep.org.springframework.util.NumberUtils;
import java.math.BigDecimal;
import java.math.BigInteger;

public class StandardTypeComparator
implements TypeComparator {
    @Override
    public int compare(Object object, Object object2) throws SpelEvaluationException {
        if (object == null) {
            return object2 == null ? 0 : -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (object instanceof Number && object2 instanceof Number) {
            Number number = (Number)object;
            Number number2 = (Number)object2;
            if (number instanceof BigDecimal || number2 instanceof BigDecimal) {
                BigDecimal bigDecimal = NumberUtils.convertNumberToTargetClass(number, BigDecimal.class);
                BigDecimal bigDecimal2 = NumberUtils.convertNumberToTargetClass(number2, BigDecimal.class);
                return bigDecimal.compareTo(bigDecimal2);
            }
            if (number instanceof Double || number2 instanceof Double) {
                return Double.compare(number.doubleValue(), number2.doubleValue());
            }
            if (number instanceof Float || number2 instanceof Float) {
                return Float.compare(number.floatValue(), number2.floatValue());
            }
            if (number instanceof BigInteger || number2 instanceof BigInteger) {
                BigInteger bigInteger = NumberUtils.convertNumberToTargetClass(number, BigInteger.class);
                BigInteger bigInteger2 = NumberUtils.convertNumberToTargetClass(number2, BigInteger.class);
                return bigInteger.compareTo(bigInteger2);
            }
            if (number instanceof Long || number2 instanceof Long) {
                return Long.compare(number.longValue(), number2.longValue());
            }
            if (number instanceof Integer || number2 instanceof Integer) {
                return Integer.compare(number.intValue(), number2.intValue());
            }
            if (number instanceof Short || number2 instanceof Short) {
                return Short.compare(number.shortValue(), number2.shortValue());
            }
            if (number instanceof Byte || number2 instanceof Byte) {
                return Byte.compare(number.byteValue(), number2.byteValue());
            }
            return Double.compare(number.doubleValue(), number2.doubleValue());
        }
        try {
            if (object instanceof Comparable) {
                return ((Comparable)object).compareTo(object2);
            }
        }
        catch (ClassCastException classCastException) {
            throw new SpelEvaluationException(classCastException, SpelMessage.NOT_COMPARABLE, object.getClass(), object2.getClass());
        }
        throw new SpelEvaluationException(SpelMessage.NOT_COMPARABLE, object.getClass(), object2.getClass());
    }
}

