/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support;

import com.gradle.maven.extension.internal.dep.org.springframework.expression.AccessException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.ConstructorExecutor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationContext;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support.ReflectionHelper;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ReflectionUtils;
import java.lang.reflect.Constructor;

public class ReflectiveConstructorExecutor
implements ConstructorExecutor {
    private final Constructor<?> ctor;
    private final Integer varargsPosition;

    public ReflectiveConstructorExecutor(Constructor<?> constructor) {
        this.ctor = constructor;
        this.varargsPosition = constructor.isVarArgs() ? Integer.valueOf(constructor.getParameterCount() - 1) : null;
    }

    @Override
    public TypedValue execute(EvaluationContext evaluationContext, Object ... objectArray) throws AccessException {
        try {
            ReflectionHelper.convertArguments(evaluationContext.getTypeConverter(), objectArray, this.ctor, this.varargsPosition);
            if (this.ctor.isVarArgs()) {
                objectArray = ReflectionHelper.setupArgumentsForVarargsInvocation(this.ctor.getParameterTypes(), objectArray);
            }
            ReflectionUtils.makeAccessible(this.ctor);
            return new TypedValue(this.ctor.newInstance(objectArray));
        }
        catch (Exception exception) {
            throw new AccessException("Problem invoking constructor: " + this.ctor, exception);
        }
    }

    public Constructor<?> getConstructor() {
        return this.ctor;
    }
}

