/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.standard;

import com.gradle.maven.extension.internal.dep.org.apache.commons.logging.Log;
import com.gradle.maven.extension.internal.dep.org.apache.commons.logging.LogFactory;
import com.gradle.maven.extension.internal.dep.org.springframework.asm.ClassWriter;
import com.gradle.maven.extension.internal.dep.org.springframework.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.springframework.asm.Opcodes;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CodeFlow;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CompiledExpression;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ClassUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ConcurrentReferenceHashMap;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ReflectionUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.util.StringUtils;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public final class SpelCompiler
implements Opcodes {
    private static final Log logger = LogFactory.getLog(SpelCompiler.class);
    private static final Map<ClassLoader, SpelCompiler> compilers = new ConcurrentReferenceHashMap<ClassLoader, SpelCompiler>();
    private volatile ChildClassLoader childClassLoader;
    private final AtomicInteger suffixId = new AtomicInteger(1);

    private SpelCompiler(ClassLoader classLoader) {
        this.childClassLoader = new ChildClassLoader(classLoader);
    }

    public CompiledExpression compile(SpelNodeImpl spelNodeImpl) {
        if (spelNodeImpl.isCompilable()) {
            Class<? extends CompiledExpression> clazz;
            if (logger.isDebugEnabled()) {
                logger.debug("SpEL: compiling " + spelNodeImpl.toStringAST());
            }
            if ((clazz = this.createExpressionClass(spelNodeImpl)) != null) {
                try {
                    return ReflectionUtils.accessibleConstructor(clazz, new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable throwable) {
                    throw new IllegalStateException("Failed to instantiate CompiledExpression for expression: " + spelNodeImpl.toStringAST(), throwable);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("SpEL: unable to compile " + spelNodeImpl.toStringAST());
        }
        return null;
    }

    private int getNextSuffix() {
        return this.suffixId.incrementAndGet();
    }

    private Class<? extends CompiledExpression> createExpressionClass(SpelNodeImpl spelNodeImpl) {
        String string = "spel/Ex" + this.getNextSuffix();
        String string2 = "com/gradle/maven/extension/internal/dep/org/springframework/expression/EvaluationContext";
        ExpressionClassWriter expressionClassWriter = new ExpressionClassWriter();
        expressionClassWriter.visit(52, 1, string, null, "com/gradle/maven/extension/internal/dep/org/springframework/expression/spel/CompiledExpression", null);
        MethodVisitor methodVisitor = expressionClassWriter.visitMethod(1, "<init>", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, "com/gradle/maven/extension/internal/dep/org/springframework/expression/spel/CompiledExpression", "<init>", "()V", false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        methodVisitor = expressionClassWriter.visitMethod(1, "getValue", "(Ljava/lang/Object;L" + string2 + ";)Ljava/lang/Object;", null, new String[]{"com/gradle/maven/extension/internal/dep/org/springframework/expression/EvaluationException"});
        methodVisitor.visitCode();
        CodeFlow codeFlow = new CodeFlow(string, expressionClassWriter);
        try {
            spelNodeImpl.generateCode(methodVisitor, codeFlow);
        }
        catch (IllegalStateException illegalStateException) {
            if (logger.isDebugEnabled()) {
                logger.debug(spelNodeImpl.getClass().getSimpleName() + ".generateCode opted out of compilation: " + illegalStateException.getMessage());
            }
            return null;
        }
        CodeFlow.insertBoxIfNecessary(methodVisitor, codeFlow.lastDescriptor());
        if ("V".equals(codeFlow.lastDescriptor())) {
            methodVisitor.visitInsn(1);
        }
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        expressionClassWriter.visitEnd();
        codeFlow.finish();
        byte[] byArray = expressionClassWriter.toByteArray();
        return this.loadClass(StringUtils.replace(string, "/", "."), byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<? extends CompiledExpression> loadClass(String string, byte[] byArray) {
        ChildClassLoader childClassLoader = this.childClassLoader;
        if (childClassLoader.getClassesDefinedCount() >= 100) {
            SpelCompiler spelCompiler = this;
            synchronized (spelCompiler) {
                ChildClassLoader childClassLoader2 = this.childClassLoader;
                if (childClassLoader == childClassLoader2) {
                    this.childClassLoader = childClassLoader = new ChildClassLoader(childClassLoader.getParent());
                } else {
                    childClassLoader = childClassLoader2;
                }
            }
        }
        return childClassLoader.defineClass(string, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpelCompiler getCompiler(ClassLoader classLoader) {
        ClassLoader classLoader2 = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
        SpelCompiler spelCompiler = compilers.get(classLoader2);
        if (spelCompiler == null) {
            Map<ClassLoader, SpelCompiler> map = compilers;
            synchronized (map) {
                spelCompiler = compilers.get(classLoader2);
                if (spelCompiler == null) {
                    spelCompiler = new SpelCompiler(classLoader2);
                    compilers.put(classLoader2, spelCompiler);
                }
            }
        }
        return spelCompiler;
    }

    private class ExpressionClassWriter
    extends ClassWriter {
        public ExpressionClassWriter() {
            super(3);
        }

        @Override
        protected ClassLoader getClassLoader() {
            return SpelCompiler.this.childClassLoader;
        }
    }

    private static class ChildClassLoader
    extends URLClassLoader {
        private static final URL[] NO_URLS = new URL[0];
        private final AtomicInteger classesDefinedCount = new AtomicInteger(0);

        public ChildClassLoader(ClassLoader classLoader) {
            super(NO_URLS, classLoader);
        }

        public Class<?> defineClass(String string, byte[] byArray) {
            Class<?> clazz = super.defineClass(string, byArray, 0, byArray.length);
            this.classesDefinedCount.incrementAndGet();
            return clazz;
        }

        public int getClassesDefinedCount() {
            return this.classesDefinedCount.get();
        }
    }
}

