/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelNode;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.InlineList;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Literal;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.PropertyOrFieldReference;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class InlineMap
extends SpelNodeImpl {
    private TypedValue constant;

    public InlineMap(int n2, int n3, SpelNodeImpl ... spelNodeImplArray) {
        super(n2, n3, spelNodeImplArray);
        this.checkIfConstant();
    }

    private void checkIfConstant() {
        SpelNode spelNode;
        boolean bl2 = true;
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            SpelNode spelNode2 = this.getChild(i2);
            if (spelNode2 instanceof Literal) continue;
            if (spelNode2 instanceof InlineList) {
                spelNode = (InlineList)spelNode2;
                if (spelNode.isConstant()) continue;
                bl2 = false;
                break;
            }
            if (spelNode2 instanceof InlineMap) {
                spelNode = (InlineMap)spelNode2;
                if (((InlineMap)spelNode).isConstant()) continue;
                bl2 = false;
                break;
            }
            if (i2 % 2 == 0 && spelNode2 instanceof PropertyOrFieldReference) continue;
            bl2 = false;
            break;
        }
        if (bl2) {
            LinkedHashMap<Object, List<Object>> linkedHashMap = new LinkedHashMap<Object, List<Object>>();
            n2 = this.getChildCount();
            for (int i3 = 0; i3 < n2; ++i3) {
                spelNode = this.getChild(i3++);
                SpelNode spelNode3 = this.getChild(i3);
                Object object = null;
                Object object2 = null;
                if (spelNode instanceof Literal) {
                    object = ((Literal)spelNode).getLiteralValue().getValue();
                } else if (spelNode instanceof PropertyOrFieldReference) {
                    object = ((PropertyOrFieldReference)spelNode).getName();
                } else {
                    return;
                }
                if (spelNode3 instanceof Literal) {
                    object2 = ((Literal)spelNode3).getLiteralValue().getValue();
                } else if (spelNode3 instanceof InlineList) {
                    object2 = ((InlineList)spelNode3).getConstantValue();
                } else if (spelNode3 instanceof InlineMap) {
                    object2 = ((InlineMap)spelNode3).getConstantValue();
                }
                linkedHashMap.put(object, (List<Object>)object2);
            }
            this.constant = new TypedValue(Collections.unmodifiableMap(linkedHashMap));
        }
    }

    @Override
    public TypedValue getValueInternal(ExpressionState expressionState) throws EvaluationException {
        if (this.constant != null) {
            return this.constant;
        }
        LinkedHashMap<Object, Object> linkedHashMap = new LinkedHashMap<Object, Object>();
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object;
            SpelNode spelNode = this.getChild(i2++);
            Object object2 = null;
            if (spelNode instanceof PropertyOrFieldReference) {
                object = (PropertyOrFieldReference)spelNode;
                object2 = ((PropertyOrFieldReference)object).getName();
            } else {
                object2 = spelNode.getValue(expressionState);
            }
            object = this.getChild(i2).getValue(expressionState);
            linkedHashMap.put(object2, object);
        }
        return new TypedValue(linkedHashMap);
    }

    @Override
    public String toStringAST() {
        StringBuilder stringBuilder = new StringBuilder("{");
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.getChild(i2++).toStringAST());
            stringBuilder.append(':');
            stringBuilder.append(this.getChild(i2).toStringAST());
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public boolean isConstant() {
        return this.constant != null;
    }

    public Map<Object, Object> getConstantValue() {
        Assert.state(this.constant != null, "No constant");
        return (Map)this.constant.getValue();
    }
}

