/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel;

import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.TypeDescriptor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationContext;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.Operation;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.OperatorOverloader;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypeComparator;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypeConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelMessage;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelParserConfiguration;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import com.gradle.maven.extension.internal.dep.org.springframework.util.CollectionUtils;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Supplier;

public class ExpressionState {
    private final EvaluationContext relatedContext;
    private final TypedValue rootObject;
    private final SpelParserConfiguration configuration;
    private Deque<TypedValue> contextObjects;
    private Deque<VariableScope> variableScopes;
    private ArrayDeque<TypedValue> scopeRootObjects;

    public ExpressionState(EvaluationContext evaluationContext, TypedValue typedValue, SpelParserConfiguration spelParserConfiguration) {
        Assert.notNull((Object)evaluationContext, "EvaluationContext must not be null");
        Assert.notNull((Object)spelParserConfiguration, "SpelParserConfiguration must not be null");
        this.relatedContext = evaluationContext;
        this.rootObject = typedValue;
        this.configuration = spelParserConfiguration;
    }

    public TypedValue getActiveContextObject() {
        if (CollectionUtils.isEmpty(this.contextObjects)) {
            return this.rootObject;
        }
        return this.contextObjects.element();
    }

    public void pushActiveContextObject(TypedValue typedValue) {
        if (this.contextObjects == null) {
            this.contextObjects = new ArrayDeque<TypedValue>();
        }
        this.contextObjects.push(typedValue);
    }

    public void popActiveContextObject() {
        if (this.contextObjects == null) {
            this.contextObjects = new ArrayDeque<TypedValue>();
        }
        try {
            this.contextObjects.pop();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalStateException("Cannot pop active context object: stack is empty");
        }
    }

    public TypedValue getRootContextObject() {
        return this.rootObject;
    }

    public TypedValue getScopeRootContextObject() {
        if (CollectionUtils.isEmpty(this.scopeRootObjects)) {
            return this.rootObject;
        }
        return this.scopeRootObjects.element();
    }

    public TypedValue assignVariable(String string, Supplier<TypedValue> supplier) {
        return this.relatedContext.assignVariable(string, supplier);
    }

    public TypedValue lookupVariable(String string) {
        Object object = this.relatedContext.lookupVariable(string);
        return object != null ? new TypedValue(object) : TypedValue.NULL;
    }

    public TypeComparator getTypeComparator() {
        return this.relatedContext.getTypeComparator();
    }

    public Class<?> findType(String string) throws EvaluationException {
        return this.relatedContext.getTypeLocator().findType(string);
    }

    public Object convertValue(Object object, TypeDescriptor typeDescriptor) throws EvaluationException {
        Object object2 = this.relatedContext.getTypeConverter().convertValue(object, TypeDescriptor.forObject(object), typeDescriptor);
        if (object2 == null) {
            throw new IllegalStateException("Null conversion result for value [" + object + "]");
        }
        return object2;
    }

    public TypeConverter getTypeConverter() {
        return this.relatedContext.getTypeConverter();
    }

    public void enterScope() {
        this.initVariableScopes().push(new VariableScope(Collections.emptyMap()));
        this.initScopeRootObjects().push(this.getActiveContextObject());
    }

    public void enterScope(String string, Object object) {
        this.initVariableScopes().push(new VariableScope(string, object));
        this.initScopeRootObjects().push(this.getActiveContextObject());
    }

    public void exitScope() {
        this.initVariableScopes().pop();
        this.initScopeRootObjects().pop();
    }

    private Deque<VariableScope> initVariableScopes() {
        if (this.variableScopes == null) {
            this.variableScopes = new ArrayDeque<VariableScope>();
            this.variableScopes.add(new VariableScope());
        }
        return this.variableScopes;
    }

    private Deque<TypedValue> initScopeRootObjects() {
        if (this.scopeRootObjects == null) {
            this.scopeRootObjects = new ArrayDeque();
        }
        return this.scopeRootObjects;
    }

    public TypedValue operate(Operation operation, Object object, Object object2) throws EvaluationException {
        OperatorOverloader operatorOverloader = this.relatedContext.getOperatorOverloader();
        if (operatorOverloader.overridesOperation(operation, object, object2)) {
            Object object3 = operatorOverloader.operate(operation, object, object2);
            return new TypedValue(object3);
        }
        String string = object == null ? "null" : object.getClass().getName();
        String string2 = object2 == null ? "null" : object2.getClass().getName();
        throw new SpelEvaluationException(SpelMessage.OPERATOR_NOT_SUPPORTED_BETWEEN_TYPES, new Object[]{operation, string, string2});
    }

    public EvaluationContext getEvaluationContext() {
        return this.relatedContext;
    }

    public SpelParserConfiguration getConfiguration() {
        return this.configuration;
    }

    private static class VariableScope {
        private final Map<String, Object> vars = new HashMap<String, Object>();

        public VariableScope() {
        }

        public VariableScope(Map<String, Object> map) {
            if (map != null) {
                this.vars.putAll(map);
            }
        }

        public VariableScope(String string, Object object) {
            this.vars.put(string, object);
        }
    }
}

