/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.common;

import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationContext;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.Expression;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.common.ExpressionUtils;

public class CompositeStringExpression
implements Expression {
    private final String expressionString;
    private final Expression[] expressions;

    public CompositeStringExpression(String string, Expression[] expressionArray) {
        this.expressionString = string;
        this.expressions = expressionArray;
    }

    @Override
    public String getValue(EvaluationContext evaluationContext, Object object) throws EvaluationException {
        StringBuilder stringBuilder = new StringBuilder();
        for (Expression expression : this.expressions) {
            String string = expression.getValue(evaluationContext, object, String.class);
            if (string == null) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    public <T> T getValue(EvaluationContext evaluationContext, Object object, Class<T> clazz) throws EvaluationException {
        String string = this.getValue(evaluationContext, object);
        return ExpressionUtils.convertTypedValue(evaluationContext, new TypedValue(string), clazz);
    }
}

