/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.core.convert.support;

import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.Converter;
import java.util.HashSet;
import java.util.Set;

final class StringToBooleanConverter
implements Converter<String, Boolean> {
    private static final Set<String> trueValues = new HashSet<String>(8);
    private static final Set<String> falseValues = new HashSet<String>(8);

    StringToBooleanConverter() {
    }

    @Override
    public Boolean convert(String string) {
        String string2 = string.trim();
        if (string2.isEmpty()) {
            return null;
        }
        if (trueValues.contains(string2 = string2.toLowerCase())) {
            return Boolean.TRUE;
        }
        if (falseValues.contains(string2)) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Invalid boolean value '" + string + "'");
    }

    static {
        trueValues.add("true");
        trueValues.add("on");
        trueValues.add("yes");
        trueValues.add("1");
        falseValues.add("false");
        falseValues.add("off");
        falseValues.add("no");
        falseValues.add("0");
    }
}

