/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.core.convert.support;

import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.ConversionService;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.TypeDescriptor;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.ConditionalGenericConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.GenericConverter;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;

final class ObjectToOptionalConverter
implements ConditionalGenericConverter {
    private final ConversionService conversionService;

    public ObjectToOptionalConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> linkedHashSet = new LinkedHashSet<GenericConverter.ConvertiblePair>(4);
        linkedHashSet.add(new GenericConverter.ConvertiblePair(Collection.class, Optional.class));
        linkedHashSet.add(new GenericConverter.ConvertiblePair(Object[].class, Optional.class));
        linkedHashSet.add(new GenericConverter.ConvertiblePair(Object.class, Optional.class));
        return linkedHashSet;
    }

    @Override
    public boolean matches(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        if (typeDescriptor2.getResolvableType().hasGenerics()) {
            return this.conversionService.canConvert(typeDescriptor, new GenericTypeDescriptor(typeDescriptor2));
        }
        return true;
    }

    @Override
    public Object convert(Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        if (object == null) {
            return Optional.empty();
        }
        if (object instanceof Optional) {
            return object;
        }
        if (typeDescriptor2.getResolvableType().hasGenerics()) {
            Object object2 = this.conversionService.convert(object, typeDescriptor, new GenericTypeDescriptor(typeDescriptor2));
            if (object2 == null || object2.getClass().isArray() && Array.getLength(object2) == 0 || object2 instanceof Collection && ((Collection)object2).isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(object2);
        }
        return Optional.of(object);
    }

    private static class GenericTypeDescriptor
    extends TypeDescriptor {
        public GenericTypeDescriptor(TypeDescriptor typeDescriptor) {
            super(typeDescriptor.getResolvableType().getGeneric(new int[0]), null, typeDescriptor.getAnnotations());
        }
    }
}

