/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.core.convert.support;

import com.gradle.maven.extension.internal.dep.org.springframework.core.CollectionFactory;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.ConversionService;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.TypeDescriptor;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.ConditionalGenericConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.GenericConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.support.ConversionUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

final class CollectionToCollectionConverter
implements ConditionalGenericConverter {
    private final ConversionService conversionService;

    public CollectionToCollectionConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Collection.class, Collection.class));
    }

    @Override
    public boolean matches(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        return ConversionUtils.canConvertElements(typeDescriptor.getElementTypeDescriptor(), typeDescriptor2.getElementTypeDescriptor(), this.conversionService);
    }

    @Override
    public Object convert(Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        boolean bl2;
        if (object == null) {
            return null;
        }
        Collection collection = (Collection)object;
        boolean bl3 = bl2 = !typeDescriptor2.getType().isInstance(object);
        if (!bl2 && collection.isEmpty()) {
            return object;
        }
        TypeDescriptor typeDescriptor3 = typeDescriptor2.getElementTypeDescriptor();
        if (typeDescriptor3 == null && !bl2) {
            return object;
        }
        Collection<Object> collection2 = CollectionFactory.createCollection(typeDescriptor2.getType(), typeDescriptor3 != null ? typeDescriptor3.getType() : null, collection.size());
        if (typeDescriptor3 == null) {
            collection2.addAll(collection);
        } else {
            for (Object e2 : collection) {
                Object object2 = this.conversionService.convert(e2, typeDescriptor.elementTypeDescriptor(e2), typeDescriptor3);
                collection2.add(object2);
                if (e2 == object2) continue;
                bl2 = true;
            }
        }
        return bl2 ? collection2 : object;
    }
}

