/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter;

import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.TypeDescriptor;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import java.util.Set;

public interface GenericConverter {
    public Set<ConvertiblePair> getConvertibleTypes();

    public Object convert(Object var1, TypeDescriptor var2, TypeDescriptor var3);

    public static final class ConvertiblePair {
        private final Class<?> sourceType;
        private final Class<?> targetType;

        public ConvertiblePair(Class<?> clazz, Class<?> clazz2) {
            Assert.notNull(clazz, "Source type must not be null");
            Assert.notNull(clazz2, "Target type must not be null");
            this.sourceType = clazz;
            this.targetType = clazz2;
        }

        public Class<?> getTargetType() {
            return this.targetType;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || object.getClass() != ConvertiblePair.class) {
                return false;
            }
            ConvertiblePair convertiblePair = (ConvertiblePair)object;
            return this.sourceType == convertiblePair.sourceType && this.targetType == convertiblePair.targetType;
        }

        public int hashCode() {
            return this.sourceType.hashCode() * 31 + this.targetType.hashCode();
        }

        public String toString() {
            return this.sourceType.getName() + " -> " + this.targetType.getName();
        }
    }
}

