/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.jacoco.core.data;

public final class ExecutionData {
    private final long id;
    private final String name;
    private final boolean[] probes;

    public ExecutionData(long l2, String string, boolean[] blArray) {
        this.id = l2;
        this.name = string;
        this.probes = blArray;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean[] getProbes() {
        return this.probes;
    }

    public boolean hasHits() {
        for (boolean bl2 : this.probes) {
            if (!bl2) continue;
            return true;
        }
        return false;
    }

    public void merge(ExecutionData executionData) {
        this.merge(executionData, true);
    }

    public void merge(ExecutionData executionData, boolean bl2) {
        this.assertCompatibility(executionData.getId(), executionData.getName(), executionData.getProbes().length);
        boolean[] blArray = executionData.getProbes();
        for (int i2 = 0; i2 < this.probes.length; ++i2) {
            if (!blArray[i2]) continue;
            this.probes[i2] = bl2;
        }
    }

    public void assertCompatibility(long l2, String string, int n2) throws IllegalStateException {
        if (this.id != l2) {
            throw new IllegalStateException(String.format("Different ids (%016x and %016x).", this.id, l2));
        }
        if (!this.name.equals(string)) {
            throw new IllegalStateException(String.format("Different class names %s and %s for id %016x.", this.name, string, l2));
        }
        if (this.probes.length != n2) {
            throw new IllegalStateException(String.format("Incompatible execution data for class %s with id %016x.", string, l2));
        }
    }

    public String toString() {
        return String.format("ExecutionData[name=%s, id=%016x]", this.name, this.id);
    }
}

