/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.reflect;

import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.ArrayUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.ClassUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.Validate;
import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.reflect.AccessibleObjects;
import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.reflect.MemberUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.stream.LangCollectors;
import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.stream.Streams;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MethodUtils {
    private static final Comparator<Method> METHOD_BY_SIGNATURE = Comparator.comparing(Method::toString);

    private static int distance(Class<?>[] classArray, Class<?>[] classArray2) {
        int n2 = 0;
        if (!ClassUtils.isAssignable(classArray, classArray2, true)) {
            return -1;
        }
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            Class<?> clazz = classArray[i2];
            Class<?> clazz2 = classArray2[i2];
            if (clazz == null || clazz.equals(clazz2)) continue;
            if (ClassUtils.isAssignable(clazz, clazz2, true) && !ClassUtils.isAssignable(clazz, clazz2, false)) {
                ++n2;
                continue;
            }
            n2 += 2;
        }
        return n2;
    }

    public static Method getAccessibleMethod(Class<?> clazz, Method method) {
        Class<?>[] classArray;
        if (!MemberUtils.isPublic(method)) {
            return null;
        }
        if (ClassUtils.isPublic(clazz)) {
            return method;
        }
        String string = method.getName();
        Method method2 = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz, string, classArray = method.getParameterTypes());
        return method2 != null ? method2 : MethodUtils.getAccessibleMethodFromSuperclass(clazz, string, classArray);
    }

    public static Method getAccessibleMethod(Method method) {
        return method != null ? MethodUtils.getAccessibleMethod(method.getDeclaringClass(), method) : null;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class<?> clazz, String string, Class<?> ... classArray) {
        while (clazz != null) {
            Class<?>[] classArray2;
            for (Class<?> clazz2 : classArray2 = clazz.getInterfaces()) {
                if (!ClassUtils.isPublic(clazz2)) continue;
                try {
                    return clazz2.getDeclaredMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Method method = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz2, string, classArray);
                    if (method == null) continue;
                    return method;
                }
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    private static Method getAccessibleMethodFromSuperclass(Class<?> clazz, String string, Class<?> ... classArray) {
        for (Class<?> clazz2 = clazz.getSuperclass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            if (!ClassUtils.isPublic(clazz2)) continue;
            return MethodUtils.getMethodObject(clazz2, string, classArray);
        }
        return null;
    }

    private static List<Class<?>> getAllSuperclassesAndInterfaces(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        List<Class<?>> list = ClassUtils.getAllSuperclasses(clazz);
        int n2 = 0;
        List<Class<?>> list2 = ClassUtils.getAllInterfaces(clazz);
        int n3 = 0;
        while (n3 < list2.size() || n2 < list.size()) {
            Class<?> clazz2 = n3 >= list2.size() || n2 < list.size() && n2 < n3 ? list.get(n2++) : list2.get(n3++);
            arrayList.add(clazz2);
        }
        return arrayList;
    }

    private static Method getInvokeMethod(boolean bl2, String string, Class<?>[] classArray, Class<? extends Object> clazz) {
        Method method;
        if (bl2) {
            method = MethodUtils.getMatchingMethod(clazz, string, classArray);
            AccessibleObjects.setAccessible(method);
        } else {
            method = MethodUtils.getMatchingAccessibleMethod(clazz, string, classArray);
        }
        return method;
    }

    public static Method getMatchingAccessibleMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        Method method2 = MethodUtils.getMethodObject(clazz, string, classArray);
        if (method2 != null) {
            return MemberUtils.setAccessibleWorkaround(method2);
        }
        Method[] methodArray = clazz.getMethods();
        List list = Stream.of(methodArray).filter(method -> method.getName().equals(string) && MemberUtils.isMatchingMethod(method, classArray)).collect(Collectors.toList());
        list.sort(METHOD_BY_SIGNATURE);
        Method method3 = null;
        for (GenericDeclaration genericDeclaration : list) {
            Method method4 = MethodUtils.getAccessibleMethod(genericDeclaration);
            if (method4 == null || method3 != null && MemberUtils.compareMethodFit(method4, method3, classArray) >= 0) continue;
            method3 = method4;
        }
        if (method3 != null) {
            MemberUtils.setAccessibleWorkaround(method3);
            if (method3.isVarArgs()) {
                GenericDeclaration genericDeclaration;
                Class<?>[] classArray2 = method3.getParameterTypes();
                genericDeclaration = classArray2[classArray2.length - 1].getComponentType();
                for (int i2 = classArray2.length - 1; i2 < classArray.length; ++i2) {
                    Class<?> clazz2 = classArray[i2];
                    if (ClassUtils.isAssignable(clazz2, genericDeclaration, true)) continue;
                    return null;
                }
            }
        }
        return method3;
    }

    public static Method getMatchingMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        Object object2;
        Objects.requireNonNull(clazz, "cls");
        Validate.notEmpty(string, "methodName", new Object[0]);
        List list = Stream.of(clazz.getDeclaredMethods()).filter(method -> method.getName().equals(string)).collect(Collectors.toList());
        List<Class<?>> list2 = MethodUtils.getAllSuperclassesAndInterfaces(clazz);
        Collections.reverse(list2);
        list2.stream().map(Class::getDeclaredMethods).flatMap(Stream::of).filter(method -> method.getName().equals(string)).forEach(list::add);
        for (Object object2 : list) {
            if (!Arrays.deepEquals(((Method)object2).getParameterTypes(), classArray)) continue;
            return object2;
        }
        TreeMap treeMap = new TreeMap();
        list.stream().filter(method -> ClassUtils.isAssignable(classArray, method.getParameterTypes(), true)).forEach(method -> {
            int n3 = MethodUtils.distance(classArray, method.getParameterTypes());
            List list = treeMap.computeIfAbsent(n3, n2 -> new ArrayList());
            list.add(method);
        });
        if (treeMap.isEmpty()) {
            return null;
        }
        object2 = (List)treeMap.values().iterator().next();
        if (object2.size() == 1 || !Objects.equals(((Method)object2.get(0)).getDeclaringClass(), ((Method)object2.get(1)).getDeclaringClass())) {
            return (Method)object2.get(0);
        }
        throw new IllegalStateException(String.format("Found multiple candidates for method %s on class %s : %s", string + Stream.of(classArray).map(String::valueOf).collect(Collectors.joining(",", "(", ")")), clazz.getName(), object2.stream().map(Method::toString).collect(Collectors.joining(",", "[", "]"))));
    }

    public static Method getMethodObject(Class<?> clazz, String string, Class<?> ... classArray) {
        try {
            return string != null && clazz != null ? clazz.getMethod(string, classArray) : null;
        }
        catch (NoSuchMethodException | SecurityException exception) {
            return null;
        }
    }

    public static Object invokeMethod(Object object, boolean bl2, String string, Object ... objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray2 = ArrayUtils.nullToEmpty(objectArray);
        return MethodUtils.invokeMethod(object, bl2, string, objectArray2, ClassUtils.toClass(objectArray2));
    }

    public static Object invokeMethod(Object object, boolean bl2, String string, Object[] objectArray, Class<?>[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Objects.requireNonNull(object, "object").getClass();
        Class<?>[] classArray2 = ArrayUtils.nullToEmpty(classArray);
        Method method = MethodUtils.getInvokeMethod(bl2, string, classArray2, clazz);
        MethodUtils.requireNonNull(method, clazz, string, classArray2);
        return method.invoke(object, MethodUtils.toVarArgs(method, ArrayUtils.nullToEmpty(objectArray)));
    }

    private static Method requireNonNull(Method method, Class<?> clazz, String string, Class<?>[] classArray) throws NoSuchMethodException {
        if (method == null) {
            throw new NoSuchMethodException(String.format("No method: %s.%s(%s)", ClassUtils.getName(clazz), string, Streams.of(classArray).map(ClassUtils::getName).collect(LangCollectors.joining(", "))));
        }
        return method;
    }

    static Object[] toVarArgs(Executable executable, Object[] objectArray) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return executable.isVarArgs() ? MethodUtils.toVarArgs(objectArray, executable.getParameterTypes()) : objectArray;
    }

    private static Object[] toVarArgs(Object[] objectArray, Class<?>[] classArray) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object[] objectArray2;
        int n2 = classArray.length;
        if (objectArray.length == n2 && ((objectArray2 = objectArray[objectArray.length - 1]) == null || objectArray2.getClass().equals(classArray[n2 - 1]))) {
            return objectArray;
        }
        objectArray2 = ArrayUtils.arraycopy(objectArray, 0, 0, n2 - 1, () -> new Object[n2]);
        Class<?> clazz = classArray[n2 - 1].getComponentType();
        Class<?> clazz2 = ClassUtils.primitiveToWrapper(clazz);
        int n3 = objectArray.length - n2 + 1;
        Object object = Array.newInstance(clazz2, n3);
        boolean bl2 = ClassUtils.isPrimitiveOrWrapper(clazz2);
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object2 = objectArray[n2 - 1 + i2];
            try {
                Array.set(object, i2, bl2 ? clazz2.getConstructor(ClassUtils.wrapperToPrimitive(clazz2)).newInstance(object2) : clazz2.cast(object2));
                continue;
            }
            catch (InstantiationException instantiationException) {
                throw new IllegalArgumentException("Cannot convert vararg #" + i2, instantiationException);
            }
        }
        if (clazz.isPrimitive()) {
            object = ArrayUtils.toPrimitive(object);
        }
        objectArray2[n2 - 1] = object;
        return objectArray2;
    }
}

