/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io.build;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.build.AbstractOriginSupplier;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.file.PathUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.util.function.IntUnaryOperator;

public abstract class AbstractStreamBuilder<T, B extends AbstractStreamBuilder<T, B>>
extends AbstractOriginSupplier<T, B> {
    private static final OpenOption[] DEFAULT_OPEN_OPTIONS = PathUtils.EMPTY_OPEN_OPTION_ARRAY;
    private int bufferSize = 8192;
    private int bufferSizeDefault = 8192;
    private int bufferSizeMax = Integer.MAX_VALUE;
    private Charset charset = Charset.defaultCharset();
    private Charset charsetDefault = Charset.defaultCharset();
    private OpenOption[] openOptions = DEFAULT_OPEN_OPTIONS;
    private final IntUnaryOperator defaultSizeChecker;
    private IntUnaryOperator bufferSizeChecker = this.defaultSizeChecker = n2 -> n2 > this.bufferSizeMax ? this.throwIae(n2, this.bufferSizeMax) : n2;

    private int checkBufferSize(int n2) {
        return this.bufferSizeChecker.applyAsInt(n2);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public InputStream getInputStream() throws IOException {
        return this.checkOrigin().getInputStream(this.getOpenOptions());
    }

    public OpenOption[] getOpenOptions() {
        return this.openOptions;
    }

    public B setBufferSize(int n2) {
        this.bufferSize = this.checkBufferSize(n2 > 0 ? n2 : this.bufferSizeDefault);
        return (B)((AbstractStreamBuilder)this.asThis());
    }

    private int throwIae(int n2, int n3) {
        throw new IllegalArgumentException(String.format("Request %,d exceeds maximum %,d", n2, n3));
    }
}

