/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts.AbstractShortIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts.ShortConsumer;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts.ShortIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts.ShortListIterator;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.function.Consumer;

public final class ShortIterators {
    public static final EmptyIterator EMPTY_ITERATOR = new EmptyIterator();

    public static int unwrap(ShortIterator shortIterator, short[] sArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + n3 + ") is negative");
        }
        if (n2 < 0 || n2 + n3 > sArray.length) {
            throw new IllegalArgumentException();
        }
        int n4 = n3;
        while (n4-- != 0 && shortIterator.hasNext()) {
            sArray[n2++] = shortIterator.nextShort();
        }
        return n3 - n4 - 1;
    }

    public static int unwrap(ShortIterator shortIterator, short[] sArray) {
        return ShortIterators.unwrap(shortIterator, sArray, 0, sArray.length);
    }

    public static class EmptyIterator
    implements ShortListIterator,
    Serializable,
    Cloneable {
        protected EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public short nextShort() {
            throw new NoSuchElementException();
        }

        @Override
        public short previousShort() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public void forEachRemaining(ShortConsumer shortConsumer) {
        }

        @Override
        @Deprecated
        public void forEachRemaining(Consumer<? super Short> consumer) {
        }

        public Object clone() {
            return EMPTY_ITERATOR;
        }
    }

    public static abstract class AbstractIndexBasedListIterator
    extends AbstractIndexBasedIterator
    implements ShortListIterator {
        protected AbstractIndexBasedListIterator(int n2, int n3) {
            super(n2, n3);
        }

        protected abstract void add(int var1, short var2);

        protected abstract void set(int var1, short var2);

        @Override
        public boolean hasPrevious() {
            return this.pos > this.minPos;
        }

        @Override
        public short previousShort() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = --this.pos;
            return this.get(this.pos);
        }

        @Override
        public int nextIndex() {
            return this.pos;
        }

        @Override
        public int previousIndex() {
            return this.pos - 1;
        }

        @Override
        public void add(short s2) {
            this.add(this.pos++, s2);
            this.lastReturned = -1;
        }

        @Override
        public void set(short s2) {
            if (this.lastReturned == -1) {
                throw new IllegalStateException();
            }
            this.set(this.lastReturned, s2);
        }
    }

    public static abstract class AbstractIndexBasedIterator
    extends AbstractShortIterator {
        protected final int minPos;
        protected int pos;
        protected int lastReturned;

        protected AbstractIndexBasedIterator(int n2, int n3) {
            this.minPos = n2;
            this.pos = n3;
        }

        protected abstract short get(int var1);

        protected abstract void remove(int var1);

        protected abstract int getMaxPos();

        @Override
        public boolean hasNext() {
            return this.pos < this.getMaxPos();
        }

        @Override
        public short nextShort() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.pos++;
            return this.get(this.lastReturned);
        }

        @Override
        public void remove() {
            if (this.lastReturned == -1) {
                throw new IllegalStateException();
            }
            this.remove(this.lastReturned);
            if (this.lastReturned < this.pos) {
                --this.pos;
            }
            this.lastReturned = -1;
        }

        @Override
        public void forEachRemaining(ShortConsumer shortConsumer) {
            while (this.pos < this.getMaxPos()) {
                ++this.pos;
                this.lastReturned = this.lastReturned;
                shortConsumer.accept(this.get(this.lastReturned));
            }
        }
    }
}

