/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.objects;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.objects.AbstractObjectSpliterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.objects.ObjectArrays;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.objects.ObjectIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.objects.ObjectSpliterator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;

public final class ObjectSpliterators {
    public static final EmptySpliterator EMPTY_SPLITERATOR = new EmptySpliterator();

    public static <K> ObjectSpliterator<K> wrap(K[] KArray, int n2, int n3, int n4) {
        ObjectArrays.ensureOffsetLength(KArray, n2, n3);
        return new ArraySpliterator<K>(KArray, n2, n3, n4);
    }

    public static <K> ObjectSpliterator<K> wrapPreSorted(K[] KArray, int n2, int n3, int n4, Comparator<? super K> comparator) {
        ObjectArrays.ensureOffsetLength(KArray, n2, n3);
        return new ArraySpliteratorWithComparator<K>(KArray, n2, n3, n4, comparator);
    }

    public static <K> ObjectSpliterator<K> asSpliterator(ObjectIterator<? extends K> objectIterator, long l2, int n2) {
        return new SpliteratorFromIterator<K>(objectIterator, l2, n2);
    }

    public static <K> ObjectSpliterator<K> asSpliteratorFromSorted(ObjectIterator<? extends K> objectIterator, long l2, int n2, Comparator<? super K> comparator) {
        return new SpliteratorFromIteratorWithComparator<K>(objectIterator, l2, n2, comparator);
    }

    public static <K> ObjectSpliterator<K> asSpliteratorUnknownSize(ObjectIterator<? extends K> objectIterator, int n2) {
        return new SpliteratorFromIterator<K>(objectIterator, n2);
    }

    public static class EmptySpliterator<K>
    implements ObjectSpliterator<K>,
    Serializable,
    Cloneable {
        protected EmptySpliterator() {
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> consumer) {
            return false;
        }

        @Override
        public ObjectSpliterator<K> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return 0L;
        }

        @Override
        public int characteristics() {
            return 16448;
        }

        @Override
        public void forEachRemaining(Consumer<? super K> consumer) {
        }

        public Object clone() {
            return EMPTY_SPLITERATOR;
        }
    }

    private static class ArraySpliterator<K>
    implements ObjectSpliterator<K> {
        final K[] array;
        private final int offset;
        private int length;
        private int curr;
        final int characteristics;

        public ArraySpliterator(K[] KArray, int n2, int n3, int n4) {
            this.array = KArray;
            this.offset = n2;
            this.length = n3;
            this.characteristics = 0x4050 | n4;
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> consumer) {
            if (this.curr >= this.length) {
                return false;
            }
            Objects.requireNonNull(consumer);
            consumer.accept(this.array[this.offset + this.curr++]);
            return true;
        }

        @Override
        public long estimateSize() {
            return this.length - this.curr;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        protected ArraySpliterator<K> makeForSplit(int n2, int n3) {
            return new ArraySpliterator<K>(this.array, n2, n3, this.characteristics);
        }

        @Override
        public ObjectSpliterator<K> trySplit() {
            int n2 = this.length - this.curr >> 1;
            if (n2 <= 1) {
                return null;
            }
            int n3 = this.curr + n2;
            int n4 = this.offset + this.curr;
            this.curr = n3;
            return this.makeForSplit(n4, n2);
        }

        @Override
        public void forEachRemaining(Consumer<? super K> consumer) {
            Objects.requireNonNull(consumer);
            K[] KArray = this.array;
            while (this.curr < this.length) {
                consumer.accept(KArray[this.offset + this.curr]);
                ++this.curr;
            }
        }
    }

    private static class ArraySpliteratorWithComparator<K>
    extends ArraySpliterator<K> {
        private final Comparator<? super K> comparator;

        public ArraySpliteratorWithComparator(K[] KArray, int n2, int n3, int n4, Comparator<? super K> comparator) {
            super(KArray, n2, n3, n4 | 0x14);
            this.comparator = comparator;
        }

        @Override
        protected ArraySpliteratorWithComparator<K> makeForSplit(int n2, int n3) {
            return new ArraySpliteratorWithComparator<K>(this.array, n2, n3, this.characteristics, this.comparator);
        }

        @Override
        public Comparator<? super K> getComparator() {
            return this.comparator;
        }
    }

    private static class SpliteratorFromIterator<K>
    implements ObjectSpliterator<K> {
        private final ObjectIterator<? extends K> iter;
        final int characteristics;
        private final boolean knownSize;
        private long size = Long.MAX_VALUE;
        private int nextBatchSize = 1024;
        private ObjectSpliterator<K> delegate = null;

        SpliteratorFromIterator(ObjectIterator<? extends K> objectIterator, int n2) {
            this.iter = objectIterator;
            this.characteristics = 0 | n2;
            this.knownSize = false;
        }

        SpliteratorFromIterator(ObjectIterator<? extends K> objectIterator, long l2, int n2) {
            this.iter = objectIterator;
            this.knownSize = true;
            this.size = l2;
            this.characteristics = (n2 & 0x1000) != 0 ? 0 | n2 : 0x4040 | n2;
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> consumer) {
            if (this.delegate != null) {
                boolean bl2 = this.delegate.tryAdvance(consumer);
                if (!bl2) {
                    this.delegate = null;
                }
                return bl2;
            }
            if (!this.iter.hasNext()) {
                return false;
            }
            --this.size;
            consumer.accept(this.iter.next());
            return true;
        }

        @Override
        public void forEachRemaining(Consumer<? super K> consumer) {
            if (this.delegate != null) {
                this.delegate.forEachRemaining(consumer);
                this.delegate = null;
            }
            this.iter.forEachRemaining(consumer);
            this.size = 0L;
        }

        @Override
        public long estimateSize() {
            if (this.delegate != null) {
                return this.delegate.estimateSize();
            }
            if (!this.iter.hasNext()) {
                return 0L;
            }
            return this.knownSize && this.size >= 0L ? this.size : Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        protected ObjectSpliterator<K> makeForSplit(K[] KArray, int n2) {
            return ObjectSpliterators.wrap(KArray, 0, n2, this.characteristics);
        }

        @Override
        public ObjectSpliterator<K> trySplit() {
            if (!this.iter.hasNext()) {
                return null;
            }
            int n2 = this.knownSize && this.size > 0L ? (int)Math.min((long)this.nextBatchSize, this.size) : this.nextBatchSize;
            Object[] objectArray = new Object[n2];
            int n3 = 0;
            while (n3 < n2 && this.iter.hasNext()) {
                objectArray[n3++] = this.iter.next();
                --this.size;
            }
            if (n2 < this.nextBatchSize && this.iter.hasNext()) {
                objectArray = Arrays.copyOf(objectArray, this.nextBatchSize);
                while (this.iter.hasNext() && n3 < this.nextBatchSize) {
                    objectArray[n3++] = this.iter.next();
                    --this.size;
                }
            }
            this.nextBatchSize = Math.min(0x2000000, this.nextBatchSize + 1024);
            ObjectSpliterator<Object> objectSpliterator = this.makeForSplit(objectArray, n3);
            if (!this.iter.hasNext()) {
                this.delegate = objectSpliterator;
                return objectSpliterator.trySplit();
            }
            return objectSpliterator;
        }
    }

    private static class SpliteratorFromIteratorWithComparator<K>
    extends SpliteratorFromIterator<K> {
        private final Comparator<? super K> comparator;

        SpliteratorFromIteratorWithComparator(ObjectIterator<? extends K> objectIterator, long l2, int n2, Comparator<? super K> comparator) {
            super(objectIterator, l2, n2 | 0x14);
            this.comparator = comparator;
        }

        @Override
        public Comparator<? super K> getComparator() {
            return this.comparator;
        }

        @Override
        protected ObjectSpliterator<K> makeForSplit(K[] KArray, int n2) {
            return ObjectSpliterators.wrapPreSorted(KArray, 0, n2, this.characteristics, this.comparator);
        }
    }

    public static abstract class LateBindingSizeIndexBasedSpliterator<K>
    extends AbstractIndexBasedSpliterator<K> {
        protected int maxPos = -1;
        private boolean maxPosFixed;

        protected LateBindingSizeIndexBasedSpliterator(int n2) {
            super(n2);
            this.maxPosFixed = false;
        }

        protected LateBindingSizeIndexBasedSpliterator(int n2, int n3) {
            super(n2);
            this.maxPos = n3;
            this.maxPosFixed = true;
        }

        protected abstract int getMaxPosFromBackingStore();

        @Override
        protected final int getMaxPos() {
            return this.maxPosFixed ? this.maxPos : this.getMaxPosFromBackingStore();
        }

        @Override
        public ObjectSpliterator<K> trySplit() {
            Spliterator spliterator = super.trySplit();
            if (!this.maxPosFixed && spliterator != null) {
                this.maxPos = this.getMaxPosFromBackingStore();
                this.maxPosFixed = true;
            }
            return spliterator;
        }
    }

    public static abstract class AbstractIndexBasedSpliterator<K>
    extends AbstractObjectSpliterator<K> {
        protected int pos;

        protected AbstractIndexBasedSpliterator(int n2) {
            this.pos = n2;
        }

        protected abstract K get(int var1);

        protected abstract int getMaxPos();

        protected abstract ObjectSpliterator<K> makeForSplit(int var1, int var2);

        protected int computeSplitPoint() {
            return this.pos + (this.getMaxPos() - this.pos) / 2;
        }

        private void splitPointCheck(int n2, int n3) {
            if (n2 < this.pos || n2 > n3) {
                throw new IndexOutOfBoundsException("splitPoint " + n2 + " outside of range of current position " + this.pos + " and range end " + n3);
            }
        }

        @Override
        public int characteristics() {
            return 16464;
        }

        @Override
        public long estimateSize() {
            return (long)this.getMaxPos() - (long)this.pos;
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> consumer) {
            if (this.pos >= this.getMaxPos()) {
                return false;
            }
            consumer.accept(this.get(this.pos++));
            return true;
        }

        @Override
        public void forEachRemaining(Consumer<? super K> consumer) {
            int n2 = this.getMaxPos();
            while (this.pos < n2) {
                consumer.accept(this.get(this.pos));
                ++this.pos;
            }
        }

        @Override
        public ObjectSpliterator<K> trySplit() {
            int n2 = this.getMaxPos();
            int n3 = this.computeSplitPoint();
            if (n3 == this.pos || n3 == n2) {
                return null;
            }
            this.splitPointCheck(n3, n2);
            int n4 = this.pos;
            ObjectSpliterator<K> objectSpliterator = this.makeForSplit(n4, n3);
            if (objectSpliterator != null) {
                this.pos = n3;
            }
            return objectSpliterator;
        }
    }
}

