/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.HashCommon;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.AbstractFloatCollection;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatArrays;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatCollection;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatConsumer;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatIterators;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatList;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatListIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatSpliterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatSpliterators;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;

public abstract class AbstractFloatList
extends AbstractFloatCollection
implements FloatList {
    protected AbstractFloatList() {
    }

    protected void ensureIndex(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is negative");
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than list size (" + this.size() + ")");
        }
    }

    protected void ensureRestrictedIndex(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is negative");
        }
        if (n2 >= this.size()) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than or equal to list size (" + this.size() + ")");
        }
    }

    @Override
    public void add(int n2, float f2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(float f2) {
        this.add(this.size(), f2);
        return true;
    }

    @Override
    public float removeFloat(int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float set(int n2, float f2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int n2, Collection<? extends Float> collection) {
        if (collection instanceof FloatCollection) {
            return this.addAll(n2, (FloatCollection)collection);
        }
        this.ensureIndex(n2);
        Iterator<? extends Float> iterator = collection.iterator();
        boolean bl2 = iterator.hasNext();
        while (iterator.hasNext()) {
            this.add(n2++, iterator.next().floatValue());
        }
        return bl2;
    }

    @Override
    public boolean addAll(Collection<? extends Float> collection) {
        return this.addAll(this.size(), collection);
    }

    @Override
    public FloatListIterator iterator() {
        return this.listIterator();
    }

    @Override
    public FloatListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public FloatListIterator listIterator(int n2) {
        this.ensureIndex(n2);
        return new FloatIterators.AbstractIndexBasedListIterator(0, n2){

            @Override
            protected final float get(int n2) {
                return AbstractFloatList.this.getFloat(n2);
            }

            @Override
            protected final void add(int n2, float f2) {
                AbstractFloatList.this.add(n2, f2);
            }

            @Override
            protected final void set(int n2, float f2) {
                AbstractFloatList.this.set(n2, f2);
            }

            @Override
            protected final void remove(int n2) {
                AbstractFloatList.this.removeFloat(n2);
            }

            @Override
            protected final int getMaxPos() {
                return AbstractFloatList.this.size();
            }
        };
    }

    @Override
    public boolean contains(float f2) {
        return this.indexOf(f2) >= 0;
    }

    @Override
    public int indexOf(float f2) {
        FloatListIterator floatListIterator = this.listIterator();
        while (floatListIterator.hasNext()) {
            float f3 = floatListIterator.nextFloat();
            if (Float.floatToRawIntBits(f2) != Float.floatToRawIntBits(f3)) continue;
            return floatListIterator.previousIndex();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(float f2) {
        FloatListIterator floatListIterator = this.listIterator(this.size());
        while (floatListIterator.hasPrevious()) {
            float f3 = floatListIterator.previousFloat();
            if (Float.floatToRawIntBits(f2) != Float.floatToRawIntBits(f3)) continue;
            return floatListIterator.nextIndex();
        }
        return -1;
    }

    @Override
    public FloatList subList(int n2, int n3) {
        this.ensureIndex(n2);
        this.ensureIndex(n3);
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
        }
        return this instanceof RandomAccess ? new FloatRandomAccessSubList(this, n2, n3) : new FloatSubList(this, n2, n3);
    }

    @Override
    public void forEach(FloatConsumer floatConsumer) {
        if (this instanceof RandomAccess) {
            int n2 = this.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                floatConsumer.accept(this.getFloat(i2));
            }
        } else {
            FloatList.super.forEach(floatConsumer);
        }
    }

    @Override
    public void removeElements(int n2, int n3) {
        this.ensureIndex(n3);
        FloatListIterator floatListIterator = this.listIterator(n2);
        int n4 = n3 - n2;
        if (n4 < 0) {
            throw new IllegalArgumentException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
        }
        while (n4-- != 0) {
            floatListIterator.nextFloat();
            floatListIterator.remove();
        }
    }

    @Override
    public void getElements(int n2, float[] fArray, int n3, int n4) {
        this.ensureIndex(n2);
        FloatArrays.ensureOffsetLength(fArray, n3, n4);
        if (n2 + n4 > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (n2 + n4) + ") is greater than list size (" + this.size() + ")");
        }
        if (this instanceof RandomAccess) {
            int n5 = n2;
            while (n4-- != 0) {
                fArray[n3++] = this.getFloat(n5++);
            }
        } else {
            FloatListIterator floatListIterator = this.listIterator(n2);
            while (n4-- != 0) {
                fArray[n3++] = floatListIterator.nextFloat();
            }
        }
    }

    @Override
    public void setElements(int n2, float[] fArray, int n3, int n4) {
        this.ensureIndex(n2);
        FloatArrays.ensureOffsetLength(fArray, n3, n4);
        if (n2 + n4 > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (n2 + n4) + ") is greater than list size (" + this.size() + ")");
        }
        if (this instanceof RandomAccess) {
            for (int i2 = 0; i2 < n4; ++i2) {
                this.set(i2 + n2, fArray[i2 + n3]);
            }
        } else {
            FloatListIterator floatListIterator = this.listIterator(n2);
            int n5 = 0;
            while (n5 < n4) {
                floatListIterator.nextFloat();
                floatListIterator.set(fArray[n3 + n5++]);
            }
        }
    }

    @Override
    public void clear() {
        this.removeElements(0, this.size());
    }

    @Override
    public int hashCode() {
        FloatListIterator floatListIterator = this.iterator();
        int n2 = 1;
        int n3 = this.size();
        while (n3-- != 0) {
            float f2 = floatListIterator.nextFloat();
            n2 = 31 * n2 + HashCommon.float2int(f2);
        }
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        int n2 = this.size();
        if (n2 != list.size()) {
            return false;
        }
        if (list instanceof FloatList) {
            FloatListIterator floatListIterator = this.listIterator();
            FloatListIterator floatListIterator2 = ((FloatList)list).listIterator();
            while (n2-- != 0) {
                if (floatListIterator.nextFloat() == floatListIterator2.nextFloat()) continue;
                return false;
            }
            return true;
        }
        FloatListIterator floatListIterator = this.listIterator();
        ListIterator listIterator = list.listIterator();
        while (n2-- != 0) {
            if (Objects.equals(floatListIterator.next(), listIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(List<? extends Float> list) {
        if (list == this) {
            return 0;
        }
        if (list instanceof FloatList) {
            FloatListIterator floatListIterator = this.listIterator();
            FloatListIterator floatListIterator2 = ((FloatList)list).listIterator();
            while (floatListIterator.hasNext() && floatListIterator2.hasNext()) {
                float f2;
                float f3 = floatListIterator.nextFloat();
                int n2 = Float.compare(f3, f2 = floatListIterator2.nextFloat());
                if (n2 == 0) continue;
                return n2;
            }
            return floatListIterator2.hasNext() ? -1 : (floatListIterator.hasNext() ? 1 : 0);
        }
        FloatListIterator floatListIterator = this.listIterator();
        ListIterator<? extends Float> listIterator = list.listIterator();
        while (floatListIterator.hasNext() && listIterator.hasNext()) {
            int n3 = ((Comparable)floatListIterator.next()).compareTo(listIterator.next());
            if (n3 == 0) continue;
            return n3;
        }
        return listIterator.hasNext() ? -1 : (floatListIterator.hasNext() ? 1 : 0);
    }

    @Override
    public boolean rem(float f2) {
        int n2 = this.indexOf(f2);
        if (n2 == -1) {
            return false;
        }
        this.removeFloat(n2);
        return true;
    }

    @Override
    public float[] toFloatArray() {
        int n2 = this.size();
        if (n2 == 0) {
            return FloatArrays.EMPTY_ARRAY;
        }
        float[] fArray = new float[n2];
        this.getElements(0, fArray, 0, n2);
        return fArray;
    }

    public boolean addAll(int n2, FloatCollection floatCollection) {
        this.ensureIndex(n2);
        FloatIterator floatIterator = floatCollection.iterator();
        boolean bl2 = floatIterator.hasNext();
        while (floatIterator.hasNext()) {
            this.add(n2++, floatIterator.nextFloat());
        }
        return bl2;
    }

    @Override
    public boolean addAll(FloatCollection floatCollection) {
        return this.addAll(this.size(), floatCollection);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        FloatListIterator floatListIterator = this.iterator();
        int n2 = this.size();
        boolean bl2 = true;
        stringBuilder.append("[");
        while (n2-- != 0) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(", ");
            }
            float f2 = floatListIterator.nextFloat();
            stringBuilder.append(String.valueOf(f2));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static class FloatRandomAccessSubList
    extends FloatSubList
    implements RandomAccess {
        public FloatRandomAccessSubList(FloatList floatList, int n2, int n3) {
            super(floatList, n2, n3);
        }

        @Override
        public FloatList subList(int n2, int n3) {
            this.ensureIndex(n2);
            this.ensureIndex(n3);
            if (n2 > n3) {
                throw new IllegalArgumentException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
            }
            return new FloatRandomAccessSubList(this, n2, n3);
        }
    }

    public static class FloatSubList
    extends AbstractFloatList
    implements Serializable {
        protected final FloatList l;
        protected final int from;
        protected int to;

        public FloatSubList(FloatList floatList, int n2, int n3) {
            this.l = floatList;
            this.from = n2;
            this.to = n3;
        }

        private boolean assertRange() {
            assert (this.from <= this.l.size());
            assert (this.to <= this.l.size());
            assert (this.to >= this.from);
            return true;
        }

        @Override
        public boolean add(float f2) {
            this.l.add(this.to, f2);
            ++this.to;
            assert (this.assertRange());
            return true;
        }

        @Override
        public void add(int n2, float f2) {
            this.ensureIndex(n2);
            this.l.add(this.from + n2, f2);
            ++this.to;
            assert (this.assertRange());
        }

        @Override
        public boolean addAll(int n2, Collection<? extends Float> collection) {
            this.ensureIndex(n2);
            this.to += collection.size();
            return this.l.addAll(this.from + n2, collection);
        }

        @Override
        public float getFloat(int n2) {
            this.ensureRestrictedIndex(n2);
            return this.l.getFloat(this.from + n2);
        }

        @Override
        public float removeFloat(int n2) {
            this.ensureRestrictedIndex(n2);
            --this.to;
            return this.l.removeFloat(this.from + n2);
        }

        @Override
        public float set(int n2, float f2) {
            this.ensureRestrictedIndex(n2);
            return this.l.set(this.from + n2, f2);
        }

        @Override
        public int size() {
            return this.to - this.from;
        }

        @Override
        public void getElements(int n2, float[] fArray, int n3, int n4) {
            this.ensureIndex(n2);
            if (n2 + n4 > this.size()) {
                throw new IndexOutOfBoundsException("End index (" + n2 + n4 + ") is greater than list size (" + this.size() + ")");
            }
            this.l.getElements(this.from + n2, fArray, n3, n4);
        }

        @Override
        public void removeElements(int n2, int n3) {
            this.ensureIndex(n2);
            this.ensureIndex(n3);
            this.l.removeElements(this.from + n2, this.from + n3);
            this.to -= n3 - n2;
            assert (this.assertRange());
        }

        @Override
        public void setElements(int n2, float[] fArray, int n3, int n4) {
            this.ensureIndex(n2);
            this.l.setElements(this.from + n2, fArray, n3, n4);
            assert (this.assertRange());
        }

        @Override
        public FloatListIterator listIterator(int n2) {
            this.ensureIndex(n2);
            return this.l instanceof RandomAccess ? new RandomAccessIter(n2) : new ParentWrappingIter(this.l.listIterator(n2 + this.from));
        }

        @Override
        public FloatSpliterator spliterator() {
            return this.l instanceof RandomAccess ? new IndexBasedSpliterator(this.l, this.from, this.to) : super.spliterator();
        }

        @Override
        public FloatList subList(int n2, int n3) {
            this.ensureIndex(n2);
            this.ensureIndex(n3);
            if (n2 > n3) {
                throw new IllegalArgumentException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
            }
            return new FloatSubList(this, n2, n3);
        }

        @Override
        public boolean rem(float f2) {
            int n2 = this.indexOf(f2);
            if (n2 == -1) {
                return false;
            }
            --this.to;
            this.l.removeFloat(this.from + n2);
            assert (this.assertRange());
            return true;
        }

        @Override
        public boolean addAll(int n2, FloatCollection floatCollection) {
            this.ensureIndex(n2);
            return super.addAll(n2, floatCollection);
        }

        private final class RandomAccessIter
        extends FloatIterators.AbstractIndexBasedListIterator {
            RandomAccessIter(int n2) {
                super(0, n2);
            }

            @Override
            protected final float get(int n2) {
                return FloatSubList.this.l.getFloat(FloatSubList.this.from + n2);
            }

            @Override
            protected final void add(int n2, float f2) {
                FloatSubList.this.add(n2, f2);
            }

            @Override
            protected final void set(int n2, float f2) {
                FloatSubList.this.set(n2, f2);
            }

            @Override
            protected final void remove(int n2) {
                FloatSubList.this.removeFloat(n2);
            }

            @Override
            protected final int getMaxPos() {
                return FloatSubList.this.to - FloatSubList.this.from;
            }

            @Override
            public void add(float f2) {
                super.add(f2);
                assert (FloatSubList.this.assertRange());
            }

            @Override
            public void remove() {
                super.remove();
                assert (FloatSubList.this.assertRange());
            }
        }

        private class ParentWrappingIter
        implements FloatListIterator {
            private FloatListIterator parent;

            ParentWrappingIter(FloatListIterator floatListIterator) {
                this.parent = floatListIterator;
            }

            @Override
            public int nextIndex() {
                return this.parent.nextIndex() - FloatSubList.this.from;
            }

            @Override
            public int previousIndex() {
                return this.parent.previousIndex() - FloatSubList.this.from;
            }

            @Override
            public boolean hasNext() {
                return this.parent.nextIndex() < FloatSubList.this.to;
            }

            @Override
            public boolean hasPrevious() {
                return this.parent.previousIndex() >= FloatSubList.this.from;
            }

            @Override
            public float nextFloat() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.parent.nextFloat();
            }

            @Override
            public float previousFloat() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                return this.parent.previousFloat();
            }

            @Override
            public void add(float f2) {
                this.parent.add(f2);
            }

            @Override
            public void set(float f2) {
                this.parent.set(f2);
            }

            @Override
            public void remove() {
                this.parent.remove();
            }
        }
    }

    static final class IndexBasedSpliterator
    extends FloatSpliterators.LateBindingSizeIndexBasedSpliterator {
        final FloatList l;

        IndexBasedSpliterator(FloatList floatList, int n2) {
            super(n2);
            this.l = floatList;
        }

        IndexBasedSpliterator(FloatList floatList, int n2, int n3) {
            super(n2, n3);
            this.l = floatList;
        }

        @Override
        protected final int getMaxPosFromBackingStore() {
            return this.l.size();
        }

        @Override
        protected final float get(int n2) {
            return this.l.getFloat(n2);
        }

        @Override
        protected final IndexBasedSpliterator makeForSplit(int n2, int n3) {
            return new IndexBasedSpliterator(this.l, n2, n3);
        }
    }
}

