/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles.AbstractDoubleIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles.DoubleIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;

public final class DoubleIterators {
    public static final EmptyIterator EMPTY_ITERATOR = new EmptyIterator();

    public static int unwrap(DoubleIterator doubleIterator, double[] dArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + n3 + ") is negative");
        }
        if (n2 < 0 || n2 + n3 > dArray.length) {
            throw new IllegalArgumentException();
        }
        int n4 = n3;
        while (n4-- != 0 && doubleIterator.hasNext()) {
            dArray[n2++] = doubleIterator.nextDouble();
        }
        return n3 - n4 - 1;
    }

    public static int unwrap(DoubleIterator doubleIterator, double[] dArray) {
        return DoubleIterators.unwrap(doubleIterator, dArray, 0, dArray.length);
    }

    public static class EmptyIterator
    implements DoubleListIterator,
    Serializable,
    Cloneable {
        protected EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public double nextDouble() {
            throw new NoSuchElementException();
        }

        @Override
        public double previousDouble() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public void forEachRemaining(DoubleConsumer doubleConsumer) {
        }

        @Override
        @Deprecated
        public void forEachRemaining(Consumer<? super Double> consumer) {
        }

        public Object clone() {
            return EMPTY_ITERATOR;
        }
    }

    public static abstract class AbstractIndexBasedListIterator
    extends AbstractIndexBasedIterator
    implements DoubleListIterator {
        protected AbstractIndexBasedListIterator(int n2, int n3) {
            super(n2, n3);
        }

        protected abstract void add(int var1, double var2);

        protected abstract void set(int var1, double var2);

        @Override
        public boolean hasPrevious() {
            return this.pos > this.minPos;
        }

        @Override
        public double previousDouble() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = --this.pos;
            return this.get(this.pos);
        }

        @Override
        public int nextIndex() {
            return this.pos;
        }

        @Override
        public int previousIndex() {
            return this.pos - 1;
        }

        @Override
        public void add(double d2) {
            this.add(this.pos++, d2);
            this.lastReturned = -1;
        }

        @Override
        public void set(double d2) {
            if (this.lastReturned == -1) {
                throw new IllegalStateException();
            }
            this.set(this.lastReturned, d2);
        }
    }

    public static abstract class AbstractIndexBasedIterator
    extends AbstractDoubleIterator {
        protected final int minPos;
        protected int pos;
        protected int lastReturned;

        protected AbstractIndexBasedIterator(int n2, int n3) {
            this.minPos = n2;
            this.pos = n3;
        }

        protected abstract double get(int var1);

        protected abstract void remove(int var1);

        protected abstract int getMaxPos();

        @Override
        public boolean hasNext() {
            return this.pos < this.getMaxPos();
        }

        @Override
        public double nextDouble() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.pos++;
            return this.get(this.lastReturned);
        }

        @Override
        public void remove() {
            if (this.lastReturned == -1) {
                throw new IllegalStateException();
            }
            this.remove(this.lastReturned);
            if (this.lastReturned < this.pos) {
                --this.pos;
            }
            this.lastReturned = -1;
        }

        @Override
        public void forEachRemaining(DoubleConsumer doubleConsumer) {
            while (this.pos < this.getMaxPos()) {
                ++this.pos;
                this.lastReturned = this.lastReturned;
                doubleConsumer.accept(this.get(this.lastReturned));
            }
        }
    }
}

