/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.HashCommon;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles.AbstractDoubleCollection;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles.DoubleArrays;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles.DoubleCollection;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles.DoubleIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles.DoubleIterators;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles.DoubleList;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles.DoubleSpliterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.doubles.DoubleSpliterators;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.DoubleConsumer;

public abstract class AbstractDoubleList
extends AbstractDoubleCollection
implements DoubleList {
    protected AbstractDoubleList() {
    }

    protected void ensureIndex(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is negative");
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than list size (" + this.size() + ")");
        }
    }

    protected void ensureRestrictedIndex(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is negative");
        }
        if (n2 >= this.size()) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than or equal to list size (" + this.size() + ")");
        }
    }

    @Override
    public void add(int n2, double d2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(double d2) {
        this.add(this.size(), d2);
        return true;
    }

    @Override
    public double removeDouble(int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double set(int n2, double d2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int n2, Collection<? extends Double> collection) {
        if (collection instanceof DoubleCollection) {
            return this.addAll(n2, (DoubleCollection)collection);
        }
        this.ensureIndex(n2);
        Iterator<? extends Double> iterator = collection.iterator();
        boolean bl2 = iterator.hasNext();
        while (iterator.hasNext()) {
            this.add(n2++, (double)iterator.next());
        }
        return bl2;
    }

    @Override
    public boolean addAll(Collection<? extends Double> collection) {
        return this.addAll(this.size(), collection);
    }

    @Override
    public DoubleListIterator iterator() {
        return this.listIterator();
    }

    @Override
    public DoubleListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public DoubleListIterator listIterator(int n2) {
        this.ensureIndex(n2);
        return new DoubleIterators.AbstractIndexBasedListIterator(0, n2){

            @Override
            protected final double get(int n2) {
                return AbstractDoubleList.this.getDouble(n2);
            }

            @Override
            protected final void add(int n2, double d2) {
                AbstractDoubleList.this.add(n2, d2);
            }

            @Override
            protected final void set(int n2, double d2) {
                AbstractDoubleList.this.set(n2, d2);
            }

            @Override
            protected final void remove(int n2) {
                AbstractDoubleList.this.removeDouble(n2);
            }

            @Override
            protected final int getMaxPos() {
                return AbstractDoubleList.this.size();
            }
        };
    }

    @Override
    public boolean contains(double d2) {
        return this.indexOf(d2) >= 0;
    }

    @Override
    public int indexOf(double d2) {
        DoubleListIterator doubleListIterator = this.listIterator();
        while (doubleListIterator.hasNext()) {
            double d3 = doubleListIterator.nextDouble();
            if (Double.doubleToRawLongBits(d2) != Double.doubleToRawLongBits(d3)) continue;
            return doubleListIterator.previousIndex();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(double d2) {
        DoubleListIterator doubleListIterator = this.listIterator(this.size());
        while (doubleListIterator.hasPrevious()) {
            double d3 = doubleListIterator.previousDouble();
            if (Double.doubleToRawLongBits(d2) != Double.doubleToRawLongBits(d3)) continue;
            return doubleListIterator.nextIndex();
        }
        return -1;
    }

    @Override
    public DoubleList subList(int n2, int n3) {
        this.ensureIndex(n2);
        this.ensureIndex(n3);
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
        }
        return this instanceof RandomAccess ? new DoubleRandomAccessSubList(this, n2, n3) : new DoubleSubList(this, n2, n3);
    }

    @Override
    public void forEach(DoubleConsumer doubleConsumer) {
        if (this instanceof RandomAccess) {
            int n2 = this.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                doubleConsumer.accept(this.getDouble(i2));
            }
        } else {
            DoubleList.super.forEach(doubleConsumer);
        }
    }

    @Override
    public void removeElements(int n2, int n3) {
        this.ensureIndex(n3);
        DoubleListIterator doubleListIterator = this.listIterator(n2);
        int n4 = n3 - n2;
        if (n4 < 0) {
            throw new IllegalArgumentException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
        }
        while (n4-- != 0) {
            doubleListIterator.nextDouble();
            doubleListIterator.remove();
        }
    }

    @Override
    public void getElements(int n2, double[] dArray, int n3, int n4) {
        this.ensureIndex(n2);
        DoubleArrays.ensureOffsetLength(dArray, n3, n4);
        if (n2 + n4 > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (n2 + n4) + ") is greater than list size (" + this.size() + ")");
        }
        if (this instanceof RandomAccess) {
            int n5 = n2;
            while (n4-- != 0) {
                dArray[n3++] = this.getDouble(n5++);
            }
        } else {
            DoubleListIterator doubleListIterator = this.listIterator(n2);
            while (n4-- != 0) {
                dArray[n3++] = doubleListIterator.nextDouble();
            }
        }
    }

    @Override
    public void setElements(int n2, double[] dArray, int n3, int n4) {
        this.ensureIndex(n2);
        DoubleArrays.ensureOffsetLength(dArray, n3, n4);
        if (n2 + n4 > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (n2 + n4) + ") is greater than list size (" + this.size() + ")");
        }
        if (this instanceof RandomAccess) {
            for (int i2 = 0; i2 < n4; ++i2) {
                this.set(i2 + n2, dArray[i2 + n3]);
            }
        } else {
            DoubleListIterator doubleListIterator = this.listIterator(n2);
            int n5 = 0;
            while (n5 < n4) {
                doubleListIterator.nextDouble();
                doubleListIterator.set(dArray[n3 + n5++]);
            }
        }
    }

    @Override
    public void clear() {
        this.removeElements(0, this.size());
    }

    @Override
    public int hashCode() {
        DoubleListIterator doubleListIterator = this.iterator();
        int n2 = 1;
        int n3 = this.size();
        while (n3-- != 0) {
            double d2 = doubleListIterator.nextDouble();
            n2 = 31 * n2 + HashCommon.double2int(d2);
        }
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        int n2 = this.size();
        if (n2 != list.size()) {
            return false;
        }
        if (list instanceof DoubleList) {
            DoubleListIterator doubleListIterator = this.listIterator();
            DoubleListIterator doubleListIterator2 = ((DoubleList)list).listIterator();
            while (n2-- != 0) {
                if (doubleListIterator.nextDouble() == doubleListIterator2.nextDouble()) continue;
                return false;
            }
            return true;
        }
        DoubleListIterator doubleListIterator = this.listIterator();
        ListIterator listIterator = list.listIterator();
        while (n2-- != 0) {
            if (Objects.equals(doubleListIterator.next(), listIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(List<? extends Double> list) {
        if (list == this) {
            return 0;
        }
        if (list instanceof DoubleList) {
            DoubleListIterator doubleListIterator = this.listIterator();
            DoubleListIterator doubleListIterator2 = ((DoubleList)list).listIterator();
            while (doubleListIterator.hasNext() && doubleListIterator2.hasNext()) {
                double d2;
                double d3 = doubleListIterator.nextDouble();
                int n2 = Double.compare(d3, d2 = doubleListIterator2.nextDouble());
                if (n2 == 0) continue;
                return n2;
            }
            return doubleListIterator2.hasNext() ? -1 : (doubleListIterator.hasNext() ? 1 : 0);
        }
        DoubleListIterator doubleListIterator = this.listIterator();
        ListIterator<? extends Double> listIterator = list.listIterator();
        while (doubleListIterator.hasNext() && listIterator.hasNext()) {
            int n3 = ((Comparable)doubleListIterator.next()).compareTo(listIterator.next());
            if (n3 == 0) continue;
            return n3;
        }
        return listIterator.hasNext() ? -1 : (doubleListIterator.hasNext() ? 1 : 0);
    }

    @Override
    public boolean rem(double d2) {
        int n2 = this.indexOf(d2);
        if (n2 == -1) {
            return false;
        }
        this.removeDouble(n2);
        return true;
    }

    @Override
    public double[] toDoubleArray() {
        int n2 = this.size();
        if (n2 == 0) {
            return DoubleArrays.EMPTY_ARRAY;
        }
        double[] dArray = new double[n2];
        this.getElements(0, dArray, 0, n2);
        return dArray;
    }

    public boolean addAll(int n2, DoubleCollection doubleCollection) {
        this.ensureIndex(n2);
        DoubleIterator doubleIterator = doubleCollection.iterator();
        boolean bl2 = doubleIterator.hasNext();
        while (doubleIterator.hasNext()) {
            this.add(n2++, doubleIterator.nextDouble());
        }
        return bl2;
    }

    @Override
    public boolean addAll(DoubleCollection doubleCollection) {
        return this.addAll(this.size(), doubleCollection);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        DoubleListIterator doubleListIterator = this.iterator();
        int n2 = this.size();
        boolean bl2 = true;
        stringBuilder.append("[");
        while (n2-- != 0) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(", ");
            }
            double d2 = doubleListIterator.nextDouble();
            stringBuilder.append(String.valueOf(d2));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static class DoubleRandomAccessSubList
    extends DoubleSubList
    implements RandomAccess {
        public DoubleRandomAccessSubList(DoubleList doubleList, int n2, int n3) {
            super(doubleList, n2, n3);
        }

        @Override
        public DoubleList subList(int n2, int n3) {
            this.ensureIndex(n2);
            this.ensureIndex(n3);
            if (n2 > n3) {
                throw new IllegalArgumentException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
            }
            return new DoubleRandomAccessSubList(this, n2, n3);
        }
    }

    public static class DoubleSubList
    extends AbstractDoubleList
    implements Serializable {
        protected final DoubleList l;
        protected final int from;
        protected int to;

        public DoubleSubList(DoubleList doubleList, int n2, int n3) {
            this.l = doubleList;
            this.from = n2;
            this.to = n3;
        }

        private boolean assertRange() {
            assert (this.from <= this.l.size());
            assert (this.to <= this.l.size());
            assert (this.to >= this.from);
            return true;
        }

        @Override
        public boolean add(double d2) {
            this.l.add(this.to, d2);
            ++this.to;
            assert (this.assertRange());
            return true;
        }

        @Override
        public void add(int n2, double d2) {
            this.ensureIndex(n2);
            this.l.add(this.from + n2, d2);
            ++this.to;
            assert (this.assertRange());
        }

        @Override
        public boolean addAll(int n2, Collection<? extends Double> collection) {
            this.ensureIndex(n2);
            this.to += collection.size();
            return this.l.addAll(this.from + n2, collection);
        }

        @Override
        public double getDouble(int n2) {
            this.ensureRestrictedIndex(n2);
            return this.l.getDouble(this.from + n2);
        }

        @Override
        public double removeDouble(int n2) {
            this.ensureRestrictedIndex(n2);
            --this.to;
            return this.l.removeDouble(this.from + n2);
        }

        @Override
        public double set(int n2, double d2) {
            this.ensureRestrictedIndex(n2);
            return this.l.set(this.from + n2, d2);
        }

        @Override
        public int size() {
            return this.to - this.from;
        }

        @Override
        public void getElements(int n2, double[] dArray, int n3, int n4) {
            this.ensureIndex(n2);
            if (n2 + n4 > this.size()) {
                throw new IndexOutOfBoundsException("End index (" + n2 + n4 + ") is greater than list size (" + this.size() + ")");
            }
            this.l.getElements(this.from + n2, dArray, n3, n4);
        }

        @Override
        public void removeElements(int n2, int n3) {
            this.ensureIndex(n2);
            this.ensureIndex(n3);
            this.l.removeElements(this.from + n2, this.from + n3);
            this.to -= n3 - n2;
            assert (this.assertRange());
        }

        @Override
        public void setElements(int n2, double[] dArray, int n3, int n4) {
            this.ensureIndex(n2);
            this.l.setElements(this.from + n2, dArray, n3, n4);
            assert (this.assertRange());
        }

        @Override
        public DoubleListIterator listIterator(int n2) {
            this.ensureIndex(n2);
            return this.l instanceof RandomAccess ? new RandomAccessIter(n2) : new ParentWrappingIter(this.l.listIterator(n2 + this.from));
        }

        @Override
        public DoubleSpliterator spliterator() {
            return this.l instanceof RandomAccess ? new IndexBasedSpliterator(this.l, this.from, this.to) : super.spliterator();
        }

        @Override
        public DoubleList subList(int n2, int n3) {
            this.ensureIndex(n2);
            this.ensureIndex(n3);
            if (n2 > n3) {
                throw new IllegalArgumentException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
            }
            return new DoubleSubList(this, n2, n3);
        }

        @Override
        public boolean rem(double d2) {
            int n2 = this.indexOf(d2);
            if (n2 == -1) {
                return false;
            }
            --this.to;
            this.l.removeDouble(this.from + n2);
            assert (this.assertRange());
            return true;
        }

        @Override
        public boolean addAll(int n2, DoubleCollection doubleCollection) {
            this.ensureIndex(n2);
            return super.addAll(n2, doubleCollection);
        }

        private final class RandomAccessIter
        extends DoubleIterators.AbstractIndexBasedListIterator {
            RandomAccessIter(int n2) {
                super(0, n2);
            }

            @Override
            protected final double get(int n2) {
                return DoubleSubList.this.l.getDouble(DoubleSubList.this.from + n2);
            }

            @Override
            protected final void add(int n2, double d2) {
                DoubleSubList.this.add(n2, d2);
            }

            @Override
            protected final void set(int n2, double d2) {
                DoubleSubList.this.set(n2, d2);
            }

            @Override
            protected final void remove(int n2) {
                DoubleSubList.this.removeDouble(n2);
            }

            @Override
            protected final int getMaxPos() {
                return DoubleSubList.this.to - DoubleSubList.this.from;
            }

            @Override
            public void add(double d2) {
                super.add(d2);
                assert (DoubleSubList.this.assertRange());
            }

            @Override
            public void remove() {
                super.remove();
                assert (DoubleSubList.this.assertRange());
            }
        }

        private class ParentWrappingIter
        implements DoubleListIterator {
            private DoubleListIterator parent;

            ParentWrappingIter(DoubleListIterator doubleListIterator) {
                this.parent = doubleListIterator;
            }

            @Override
            public int nextIndex() {
                return this.parent.nextIndex() - DoubleSubList.this.from;
            }

            @Override
            public int previousIndex() {
                return this.parent.previousIndex() - DoubleSubList.this.from;
            }

            @Override
            public boolean hasNext() {
                return this.parent.nextIndex() < DoubleSubList.this.to;
            }

            @Override
            public boolean hasPrevious() {
                return this.parent.previousIndex() >= DoubleSubList.this.from;
            }

            @Override
            public double nextDouble() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.parent.nextDouble();
            }

            @Override
            public double previousDouble() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                return this.parent.previousDouble();
            }

            @Override
            public void add(double d2) {
                this.parent.add(d2);
            }

            @Override
            public void set(double d2) {
                this.parent.set(d2);
            }

            @Override
            public void remove() {
                this.parent.remove();
            }
        }
    }

    static final class IndexBasedSpliterator
    extends DoubleSpliterators.LateBindingSizeIndexBasedSpliterator {
        final DoubleList l;

        IndexBasedSpliterator(DoubleList doubleList, int n2) {
            super(n2);
            this.l = doubleList;
        }

        IndexBasedSpliterator(DoubleList doubleList, int n2, int n3) {
            super(n2, n3);
            this.l = doubleList;
        }

        @Override
        protected final int getMaxPosFromBackingStore() {
            return this.l.size();
        }

        @Override
        protected final double get(int n2) {
            return this.l.getDouble(n2);
        }

        @Override
        protected final IndexBasedSpliterator makeForSplit(int n2, int n3) {
            return new IndexBasedSpliterator(this.l, n2, n3);
        }
    }
}

